<?php

if (! defined('ABSPATH')) {
exit;
}

class CreamailerForNinjaFormsField extends NF_Abstracts_Input
{
    private $settings;

    protected $_name = 'creamailer_for_ninja_forms_field';
    protected $_nicename = 'Creamailer Opt-in';
    protected $_section = 'misc';
    protected $_type = 'checkbox';
    protected $_icon = 'check-square-o';
    protected $_templates = 'checkbox';
    protected $_test_value = 0;
    protected $_settings = ['checkbox_default_value', 'checked_calc_value', 'unchecked_calc_value'];
    protected $_settings_exclude = ['default', 'placeholder', 'input_limit_set', 'checkbox_values'];

    /**
     * NF_Fields_Checkbox constructor.
     * @since 1.0.0
     */
    public function __construct()
    {
        parent::__construct();

        $this->settings = get_option( 'creamailer-for-ninja-forms' );
        $this->_settings['label_pos']['value'] = 'right';

        $this->_nicename = $this->settings['optin_text'] ?? 'Creamailer Opt-in';

        add_filter('ninja_forms_custom_columns', [$this, 'custom_columns'], 10, 2);
    }

    /**
     * Admin Form Element
     * Display the checkbox on the edit submissions area.
     * @param $id Field ID.
     * @param $value Field value.
     * @return string HTML used for display of checkbox.
     * @since 1.0.0
     *
     */
    public function admin_form_element($id, $value)
    {
        // If the checkboxes value is one...
        if (1 === (int)$value) {
            // ...this variable to checked.
            $checked = 'checked';
        } else {
            // ...else leave the variable empty.
            $checked = '';
        }

        // Return HTML to be output to the submission edit page.
        return "<input type='hidden' name='fields[$id]' value='0' ><input type='checkbox' name='fields[$id]' value='1' id='' $checked>";
    }

    /**
     * Custom Columns
     * Creates what is displayed in the columns on the submissions page.
     * @param string $value checkbox value
     * @param CreamailerForNinjaFormsField $field field model.
     * @return $value string|void
     * @since 1.0.0
     *
     */
    public function custom_columns($value, $field)
    {
        // If the field type is equal to checkbox...
        if ('creamailer_for_ninja_forms_field' === $field->get_setting('type')) {
            // Backwards compatibility check for the new checked value setting.
            if (null === $field->get_setting('checked_value') && 1 === (int)$value) {
                return __('Checked', 'creamailer-for-ninja-forms');
            } elseif (null === $field->get_setting('unchecked_value') && 0 === (int)$value) {
                return __('Unchecked', 'creamailer-for-ninja-forms');
            }

            // If the field value is set to 1....
            if (1 === (int)$value) {
                // Set the value to the checked value setting.
                $value = $field->get_setting('checked_value');
            } else {
                // Else set the value to the unchecked value setting.
                $value = $field->get_setting('unchecked_value');
            }
        }
        return $value;
    }
}
