<?php

class CreamailerForNinjaFormsAction extends NF_Abstracts_Action
{
    private $settings;

    protected $_name = 'creamailer_for_ninja_forms_action';
    protected $_nicename = 'Send to Creamailer';
    protected $_tags = ['newsletter'];
    protected $_timing = 'normal';
    protected $_priority = '10';
    protected $_settings = [];

    public function __construct()
    {
        $this->settings = get_option( 'creamailer-for-ninja-forms' );
    }

    public function process($action_settings, $form_id, $data)
    {
        $email = null;
        $name = null;

        foreach ($data['fields'] as $field_data) {
            if ($field_data['type'] === 'email') {
                $email = $field_data['value'];
            }

            if ($field_data['name'] === 'name') {
                $name = $field_data['value'];
            }
        }

        if (empty($email)) {
            return;
        }

        if (!isset($this->settings['hide_consent']) || !$this->settings['hide_consent']) {
            foreach ($data['fields'] as $field_data) {
                if ($field_data['type'] === 'creamailer_for_ninja_forms_field' && empty($field_data['value'])) {
                    return;
                }
            }
        }

        $creamailer = new CreamailerApiForNinjaForms(
            $this->settings['access_token'],
            $this->settings['shared_secret'],
            $this->settings['list_id']
        );

        $sendAutoresponders = isset($this->settings['send_autoresponders']) && $this->settings['send_autoresponders'];
        $sendAutorespondersIfExists = isset($this->settings['send_autoresponders_if_exists']) && $this->settings['send_autoresponders_if_exists'];

        $creamailer->add_subscriber($email, $name, $sendAutoresponders, $sendAutorespondersIfExists);
    }
}
