<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.creamailer.fi
 * @since             1.0.0
 * @package           Creamailer
 *
 * @wordpress-plugin
 * Plugin Name:       Creamailer for Ninja Forms
 * Description:       Creamailer integration plugin for Ninja Forms.
 * Version:           1.0.0
 * Author:            Creamailer
 * Author URI:        https://www.creamailer.fi/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       creamailer-for-ninja-forms
 * Domain Path:       /languages
 * Requires Plugins:  ninja-forms
 * Requires at least: 6.3
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'CREAMAILER_FOR_NINJA_FORMS_VERSION', '1.0.0' );

define( 'CREAMAILER_NINJA_FORMS_PLUGIN_URL', plugins_url( '', __FILE__ ));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-creamailer-for-ninja-forms-activator.php
 */
function creamailer_for_ninja_forms_activate() {
	require_once plugin_dir_path(__FILE__) . 'includes/class-creamailer-for-ninja-forms-activator.php';
	Creamailer_For_NinjaForms_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-creamailer-for-ninja-forms-deactivator.php
 */
function creamailer_for_ninja_forms_deactivate() {
	require_once plugin_dir_path(__FILE__) . 'includes/class-creamailer-for-ninja-forms-deactivator.php';
	Creamailer_For_NinjaForms_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'creamailer_for_ninja_forms_activate' );
register_deactivation_hook( __FILE__, 'creamailer_for_ninja_forms_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-creamailer-for-ninja-forms.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function creamailer_for_ninja_forms_run() {

	$plugin = new Creamailer_For_NinjaForms();
	$plugin->run();

}

// Run after ninja forms is loaded
//add_action('ninja_forms_loaded', 'creamailer_for_ninja_forms_run', 20);
add_action('plugins_loaded', 'creamailer_for_ninja_forms_run', 8);
