(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

})( jQuery );

//creamailer-for-ninja-forms-plugin-autoresponders-field
window.onload = function () {
	function sanitycheck_for_autoresponders () {
		if (document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-field').checked) {
			document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-if-exists-field').disabled = false;
		} else {
			document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-if-exists-field').checked = false;
			document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-if-exists-field').disabled = true;
		}

	}

	document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-field').addEventListener('change', (event) => {
		sanitycheck_for_autoresponders();
	});

	document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-text').addEventListener('click', (event) => {
		document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-field').checked = !document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-field').checked;
		sanitycheck_for_autoresponders();
	});

	document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-if-exists-text').addEventListener('click', (event) => {
		if (document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-field').checked) {
			document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-if-exists-field').checked =  !document.getElementById('creamailer-for-ninja-forms-plugin-send-autoresponders-if-exists-field').checked;
		}
	});

	document.getElementById('creamailer-for-ninja-forms-plugin-error-log-text').addEventListener('click', (event) => {
		document.getElementById('creamailer-for-ninja-forms-plugin-error-log-field').checked = !document.getElementById('creamailer-for-ninja-forms-plugin-error-log-field').checked;
	});


	sanitycheck_for_autoresponders();
}

