<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://www.creamailer.fi
 * @since      1.0.0
 *
 * @package    CreamailerFeaturedImageForRss
 * @subpackage CreamailerFeaturedImageForRss/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * @package    CreamailerFeaturedImageForRss
 * @subpackage CreamailerFeaturedImageForRss/public
 * @author     Creamailer <info@creamailer.fi>
 */
class Creamailer_Featured_Image_For_Rss_Public
{
    private $settings;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     */
    public function __construct()
    {
        $this->settings = get_option('creamailer-featured-image-for-rss');
    }

    function add_media_namespace()
    {
        echo 'xmlns:media="http://search.yahoo.com/mrss/"';
    }

    function add_featured_image_to_feed() {
        global $post;

        if ($post instanceof WP_Post && has_post_thumbnail($post->ID)) {
            $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'medium');

            if (false !== $image) {
                echo '<media:content url="' . esc_html($image[0]) . '" type="image/jpeg" medium="image" width="' . esc_html($image[1]) . '" height="' . esc_html($image[2]) . '"></media:content>';
            }
        }
    }

    public function add_hooks()
    {
        if (isset($this->settings['enabled']) && $this->settings['enabled']) {
            add_action('rss2_ns', array($this, 'add_media_namespace'));
            add_action('rss2_item', array($this, 'add_featured_image_to_feed'));
        }
    }
}
