<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.creamailer.fi
 * @since             1.0.0
 * @package           CreamailerFeaturedImageForRss
 *
 * @wordpress-plugin
 * Plugin Name:       Creamailer featured image for RSS
 * Plugin URI:        https://www.creamailer.fi
 * Description:       Creamailer add featured image to RSS feed.
 * Version:           1.0.1
 * Author:            Creamailer
 * Author URI:        https://www.creamailer.fi/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       creamailer-featured-image-for-rss
 * Requires at least: 5.0
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'CREAMAILER_FEATURED_IMAGE_FOR_RSS_VERSION', '1.0.1' );

define( 'CREAMAILER_FEATURED_IMAGE_FOR_RSS_PLUGIN_URL', plugins_url( '', __FILE__ ));

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function creamailer_featured_image_for_rss_run() {
    $plugin_name = 'creamailer-featured-image-for-rss';

    if ( is_admin() ) {
        // we are in admin mode
        require_once __DIR__ . '/admin/class-creamailer-featured-image-for-rss-admin.php';

        $admin = new Creamailer_Featured_Image_For_Rss_Admin('creamailer-featured-image-for-rss', CREAMAILER_FEATURED_IMAGE_FOR_RSS_VERSION);
        $admin->add_hooks();
        $admin->enqueue_styles();
    }

    require_once __DIR__ . '/public/class-creamailer-featured-image-for-rss-public.php';

	$plugin = new Creamailer_Featured_Image_For_Rss_Public();
    $plugin->add_hooks();
}

creamailer_featured_image_for_rss_run();
