<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.creamailer.fi
 * @since      1.0.0
 *
 * @package    CreamailerFeaturedImageForRss
 * @subpackage CreamailerFeaturedImageForRss/admin
 * @author     Creamailer <info@creamailer.fi>
 */
class Creamailer_Featured_Image_For_Rss_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

    protected $settings;

    /**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;

        $this->settings = get_option( 'creamailer-featured-image-for-rss' );
    }

    public function add_hooks() {
        add_action( 'admin_init', array( $this, 'admin_init_hook' ));
        add_action( 'admin_menu', array( $this, 'admin_menu_hook' ));
    }

    public function admin_menu_hook() {
        add_options_page(
            'Creamailer featured image for RSS settings ',
            'Creamailer RSS',
            'manage_options',
            'creamailer_featured_image_for_rss_settings',
            array( $this, 'render_settings_page' )
        );
    }

    public function sanitize_settings( $input ) {
        $output = array();
        $output['enabled'] = isset( $input['enabled'] ) ? '1' : '0';

        return $output;
    }

    public function admin_init_hook() {
        register_setting(
            'creamailer-featured-image-for-rss',
            'creamailer-featured-image-for-rss',
            array(
                'sanitize_callback' => array( $this, 'sanitize_settings' ),
            )
        );

        add_settings_section(
            'creamailer-featured-image-for-rss',
            '',
            array( $this, 'settings_section_html' ),
            'creamailer_featured_image_for_rss_settings'
        );

        add_settings_field(
            'enabled',
            '',
            array( $this, 'print_enabled_field' ),
            'creamailer_featured_image_for_rss_settings',
            'creamailer-featured-image-for-rss',
            'creamailer-featured-image-for-rss'
        );
    }

    public function render_settings_page() {
        printf( '<div id="creamailer-featured-image-for-rss-plugin-settings">' );
        printf( '<form action="options.php" method="post">' );
        settings_fields( 'creamailer-featured-image-for-rss' );
        do_settings_sections( 'creamailer_featured_image_for_rss_settings' );
        submit_button();
        printf( '</form>' );
        printf( '<hr />' );
        printf( '<h1>' . esc_html__( 'Need help?', 'creamailer-featured-image-for-rss' ) . '</h1>' );
        printf( '<a href="https://tuki.creamailer.fi/hc/fi/articles/29471516815122">' . esc_html__( 'See the official help article', 'creamailer-featured-image-for-rss' ) . '</a>' );
        printf( '</div>' );
    }

    public function settings_section_html() {
        printf( '<h1>' . esc_html__( 'Creamailer featured image for RSS settings', 'creamailer-featured-image-for-rss' ) . '</h1>' );
        printf( '<div id="creamailer-featured-image-for-rss-settings-header">' );
        printf( '<img src="%s/admin/images/logo.png" alt="Creamailer" /> ', esc_url(  CREAMAILER_FEATURED_IMAGE_FOR_RSS_PLUGIN_URL ) );
        printf( '<sup>Version %s</sup>', esc_html( CREAMAILER_FEATURED_IMAGE_FOR_RSS_VERSION ) );
        printf( '</div>' );
    }

    public function print_enabled_field() {
        printf( '<hr id="creamailer-featured-image-for-rss-on-hr" />' );
        printf(
            '<input id="creamailer-featured-image-for-rss-on-field" type="checkbox" value="1" name="creamailer-featured-image-for-rss[enabled]" %s />',
            (isset($this->settings['enabled']) && $this->settings['enabled'] === '1') ? 'checked="checked"' : ''
        );
        printf( '<label for="creamailer-featured-image-for-rss-on-field"><span id="creamailer-featured-image-for-rss-on-text">' . esc_html__( 'Add featured image to RSS feed', 'creamailer-featured-image-for-rss' ) . '</span></label>' );
    }

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		wp_enqueue_style( $this->plugin_name, plugin_dir_url(__FILE__) . 'css/creamailer-featured-image-for-rss-admin.css', array(), $this->version, 'all' );
	}
}
