<?php
/*
Plugin Name: Coverbox Long Term Capital Gain Tax Calculator
Description: A plugin to calculate Long Term Capital Gain Tax.
Version: 1.4
Author: jkachhara
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

// Function to generate month dropdown
function ltcg_month_dropdown($name, $id) {
    $months = [
        1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
        5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
        9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
    ];
    echo '<select name="' . esc_attr($name) . '" id="' . esc_attr($id) . '">';
    foreach ($months as $num => $month) {
        echo '<option value="' . esc_attr($num) . '">' . esc_html($month) . '</option>';
    }
    echo '</select>';
}

function ltcg_year_input($name, $id, $placeholder = 'Year') {
    echo '<input type="number" name="' . esc_attr($name) . '" id="' . esc_attr($id) . '" placeholder="' . esc_attr($placeholder) . '" required>';
}

function ltcg_number_input($name, $id, $placeholder, $required = true) {
    $req = $required ? 'required' : '';
    echo '<input type="number" name="' . esc_attr($name) . '" id="' . esc_attr($id) . '" placeholder="' . esc_attr($placeholder) . '" ' . esc_attr($req) . '>';
}

function ltcg_calculator_form($form_id = 'ltcg-calculator') {
    ?>
    <form id="<?php echo esc_attr($form_id); ?>" class="ltcg-calculator-card">
        <h3>Purchase & Sale Date</h3>
        <div class="ltcg-grid">
            <div>
                <label>Purchase Month</label>
                <?php ltcg_month_dropdown('purchase_month', $form_id . '_purchase_month'); ?>
            </div>
            <div>
                <label>Purchase Year</label>
                <?php ltcg_year_input('purchase_year', $form_id . '_purchase_year'); ?>
            </div>
            <div>
                <label>Sale Month</label>
                <?php ltcg_month_dropdown('sale_month', $form_id . '_sale_month'); ?>
            </div>
            <div>
                <label>Sale Year</label>
                <?php ltcg_year_input('sale_year', $form_id . '_sale_year'); ?>
            </div>
        </div>

        <h3>Details</h3>
        <div class="ltcg-grid">
            <div>
                <label>Purchase Price</label>
                <?php ltcg_number_input('purchase_price', $form_id . '_purchase_price', 'Purchase Price'); ?>
            </div>
            <div>
                <label>Sale Price</label>
                <?php ltcg_number_input('sale_price', $form_id . '_sale_price', 'Sale Price'); ?>
            </div>
            <div style="grid-column: 1 / -1;">
                <label>Expenses</label>
                <?php ltcg_number_input('expenses', $form_id . '_expenses', 'Expenses', false); ?>
            </div>
        </div>

        <button type="submit">Calculate</button>
    </form>
    <div id="<?php echo esc_attr($form_id . '_result'); ?>" class="ltcg-calculator-result"></div>
    <?php
}

function ltcg_calculator_shortcode($atts) {
    $atts = shortcode_atts(['id' => 'ltcg-calculator'], $atts);
    ltcg_calculator_form($atts['id']);
}
add_shortcode('ltcg_calculator', 'ltcg_calculator_shortcode');

function ltcg_calculator_scripts() {
    wp_enqueue_script('ltcg-calculator-js', plugin_dir_url(__FILE__) . 'assets/js/calculator.js', array('jquery'), '1.0', true);
    wp_enqueue_style('ltcg-calculator-css', plugin_dir_url(__FILE__) . 'assets/css/calculator.css', array(), '1.0');
}
add_action('wp_enqueue_scripts', 'ltcg_calculator_scripts');
