jQuery(document).ready(function($) {
    $('form[id^="ltcg-calculator"]').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this);
        function getNumber(selector) {
            var val = parseFloat($form.find(selector).val());
            return isNaN(val) ? 0 : val;
        }
        var purchasePrice = getNumber('input[name="purchase_price"]');
        var salePrice = getNumber('input[name="sale_price"]');
        var expenses = getNumber('input[name="expenses"]');
        var gain = salePrice - purchasePrice - expenses;
        var $result = $form.next('div[id$="_result"]');
        $result.empty();
        var resultText;
        if (gain > 0) {
            resultText = document.createTextNode('Long Term Capital Gain: ₹' + gain.toFixed(2));
            $result.css({'background-color': '#d4edda','color': '#155724'});
        } else {
            resultText = document.createTextNode('No Long Term Capital Gain');
            $result.css({'background-color': '#f8d7da','color': '#721c24'});
        }
        $result.append(resultText);
    });
});