<?php

/**
 * Form to Google Sheet Action
 */

if (!defined('ABSPATH')) {
    exit;
}

use HelloPlus\Modules\Forms\Classes\Action_Base;
//phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedClassFound
class Sheet_HelloPlus_Action extends Action_Base
{
    public function __construct() {
        
        // Only enqueue in Elementor editor
        if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
            add_action('elementor/editor/after_enqueue_scripts', [$this, 'enqueue_editor_scripts']);
        }
    }

    public function enqueue_editor_scripts() {

		wp_localize_script(
			'coolplugin-editor-js',
			'ccfefFormDBMarketing',
			[
				'nonce'    => wp_create_nonce('ccfef_install_nonce'),
				'plugin'   => 'form-db',
				'ajax_url' => admin_url('admin-ajax.php'),
				'formdb_type' => 'formdb_notice',
				'formdb_dismiss_nonce' => wp_create_nonce('ccfef_dismiss_nonce_formdb_notice'),
			]
		);
    }

    /**
     * Unique action name (slug!)
     */
    public function get_name() : string {
        return 'Save Submissions in Google Sheet';
    }

    /**
     * Label shown in UI
     */
    public function get_label(): string {
        return esc_html__('Save Submissions in Google Sheet', 'country-code-field-for-elementor-form');
    }

    public function add_prefix( $id ) {
        return 'fdbgp_' . $id;
    }

    /**
     * Settings panel
     */
    public function register_settings_section($widget) {
        $widget->start_controls_section(
             $this->add_prefix('section_google_sheets'),
            [
                'label'     => esc_html__('Save Submissions in Google Sheet', 'country-code-field-for-elementor-form'),
                'condition' => [
                    'cool_formkit_submit_actions' => $this->get_name(),
                ],
            ]
        );

        $widget->add_control(
            $this->add_prefix('fdbgp_plugin_marketing'),
            [
                'name'      => 'fdbgp_plugin_marketing',
                'label'     => '',
                'type'      => \Elementor\Controls_Manager::RAW_HTML,
                'raw'       => '<div class="elementor-control-raw-html cool-form-wrp"><div class="elementor-control-notice elementor-control-notice-type-info">
											<div class="elementor-control-notice-icon"><img class="ccfef-highlight-icon" src="' . esc_url(CCFEF_PLUGIN_URL . 'admin/marketing/images/ccfef-highlight-icon.svg') . '" width="250" alt="Highlight Icon" /></div>
											<div class="elementor-control-notice-main">
												
												<div class="elementor-control-notice-main-content">Save Form Submissions to Google Sheets.</div>
												<div class="elementor-control-notice-main-actions">
												<button type="button" class="elementor-button e-btn e-info e-btn-1 ccfef-install-plugin">Install FormsDB</button>
											</div></div>
											</div></div>',

            ]
        );

        $widget->end_controls_section();
    }

    /**
     * Export handler
     */
    public function on_export($element) {
    }

    /**
     * Run on submit
     */
    public function run($record, $ajax_handler) {
        
    }

    
}