<?php

class CoralPayTransaction {

    /**
     * Unique identifier of the transaction from the merchant’s end.
     * @var string
     */
    public string $traceId;

    /**
     * Currency
     * @var string
     */
    public string $currency;

    /**
     * Amount of the transaction
     * @var float
     */
    public float $amount;

    /**
     * Redirect url after successful payment
     * @var string
     */
    public string $redirectUrl;


    public function __construct($order)
    {
        $this->amount = $order->get_total();
        $this->currency = $order->get_currency();

        $this->redirectUrl = $this->buildRedirectUrl($order);

        // Generate trace id
        $this->traceId = uniqid()."-".$order->get_id();

    }

    private function buildRedirectUrl($order): string
    {
        $custom_nonce = wp_create_nonce('verify_payment');

        $url = WC()->api_request_url('coralpay_gateway');
        $url .= '?order_id='.$order->get_id().'&_wpnonce='.$custom_nonce.'&q=payment';

        return $url;
    }
}