<?php

class CoralpayConfig {

    /**
     * @var string
     */
    public static string $test_url = "https://testdev.coralpay.com/GwApi-wp";

    /**
     * @var string
     */
    public static String $live_url = "https://cpg.coralpay.com/gwapi";

    public static array $defaultConfig = [
        "mode" => "yes",
        "live_username" => "",
        "live_password" => "",
        "test_username" => "",
        "test_password" => "",
        "merchant_id" => "",
        "autocomplete_order" => false,
        "title" => "",
        "description" => "",
    ];

    public static function getSetttings(){
        $options = get_option('woocommerce_coralpay_settings', []);
        return array_merge(self::$defaultConfig, $options);
    }

    /**
     * @return array
     */
    public static function getCredentials(): array
    {
        $data = self::getSetttings();

        if($data['mode'] == 'yes'){
            return [
                'username' => $data['live_username'],
                'password' => $data['live_password'],
                'url' => CoralpayConfig::$live_url
            ];
        }

        return [
            'username' => $data['test_username'],
            'password' => $data['test_password'],
            'url' => CoralpayConfig::$test_url
        ];
    }

    public static function getMerchantId(): ?String {
        $data = self::getSetttings();
        return $data['merchant_id'];
    }

    public static function canAutoCompleteOrder(): ?String {
        $data = get_option('woocommerce_coralpay_settings');
        if(isset($data['autocomplete_order'])){
            return $data['autocomplete_order'] == 'yes';
        }
        return false;
    }
}