/**
 * Import WooCommerce dependencies
 */
import { registerPaymentMethod } from '@woocommerce/blocks-registry';
import { __ } from '@wordpress/i18n'; 

import React from 'react';


/**
 * Payment Method Definition
 */
const coralpayPaymentMethod = {
    name: 'coralpay', 
    label: (
        <div style={{ display: 'flex', alignItems: 'center' }}>
            {/* Logo */}
            <img
                src={coralpayData.logoUrl}
                alt={__('CoralPay Logo', 'coralpay')}
                style={{ width: '30px', height: '30px', marginRight: '10px' }}
            />
            {/* Label Text */}
            <span>{coralpayData.title ||  __('CoralPay Payment', 'coralpay')}</span>
        </div>
    ),
    content: <p>{coralpayData.description ||  __( 'Pay securely using CoralPay.', 'coralpay' ) }</p>,
    edit: <p>{ __( 'CoralPay Payment Settings', 'coralpay' ) }</p>, 
    placeOrderButtonLabel:  __( 'Pay securely using CoralPay.', 'coralpay' ),
	ariaLabel: coralpayData.description || __( 'Pay securely using CoralPay.', 'coralpay' ),
    canMakePayment: () => true
}; 
/**
 * Register Payment Method
 */
registerPaymentMethod( coralpayPaymentMethod );
