<?php
use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class Coralpay_WC_Gateway_Blocks_Support extends AbstractPaymentMethodType {

    protected $name = 'coralpay';

    private $gateway;

    public function initialize()
    {
        $this->settings = CoralpayConfig::getSetttings();
        $gateways       = WC()->payment_gateways->payment_gateways();
        $this->gateway  = $gateways[ $this->name ];
    }

    public function is_active() {
        return $this->gateway->is_available();
    }

    public function get_supported_features(): array {
        return $this->gateway->supports;
    }

    public static function plugin_url() {
        return untrailingslashit( plugins_url( '/', WC_CORALPAY_PLUGIN_FILE ) );
    }

    /**
     * Returns an array of scripts/handles to be registered for this payment method.
     *
     * @return array
     */
    public function get_payment_method_script_handles(): array
    {
        if(!$this->is_active()){
            return [];
        }
        $script_path       = '/assets/js/index.js';
        $script_asset      =   array(
            'dependencies' => array('wc-blocks-registry', 'wc-settings', 'wp-html-entities'),
            'version'      => '1.0.0'
        );
        $script_url        =  self::plugin_url(). $script_path;

        wp_register_script(
            'wc-coralpay-payments-blocks',
            $script_url,
            $script_asset[ 'dependencies' ],
            $script_asset[ 'version' ],
            true
        );

        wp_localize_script( 'wc-coralpay-payments-blocks', 'coralpayData', array(
            'logoUrl' => plugin_dir_url( __DIR__ ). '../assets/img/logo.svg',
            'title' => $this->settings['title'],
            'description' => $this->settings['description'],
        ));

        return [ 'wc-coralpay-payments-blocks' ];
    }

}