<?php
/**
 * Plugin Name: CoralPay Gateway For WooCommerce
 * Plugin URI: https://www.coralpay.com/
 * Description: Official WooCommerce payment gateway for CoralPay.
 * Version: 1.0.3
 * Author: CoralPay Developers
 * Requires at least:      5.8
 * Requires PHP:           7.4
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires Plugins: woocommerce
 **/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! defined( 'WC_CORALPAY_PLUGIN_FILE' ) ) {
    define( 'WC_CORALPAY_PLUGIN_FILE', __FILE__ );
}

add_action( 'plugins_loaded', 'init_coralpay_gateway', 10);

function init_coralpay_gateway(){
    if ( !class_exists( 'WC_Payment_Gateway' ) ) return;

    $gateway_file = dirname(WC_CORALPAY_PLUGIN_FILE) . '/includes/class-coralpay-wc-payment-gateway.php';
    if (file_exists($gateway_file)) {
        require_once $gateway_file;
    } else {
        return;
    }

    add_filter('woocommerce_payment_gateways', 'add_coralpay_to_woocommerce_gateway_list');
    add_filter( 'http_request_args', function( $args ) {
        $args['reject_unsafe_urls'] = false;
        return $args;
    });
    add_action( 'woocommerce_blocks_loaded', 'coralpay_woocommerce_blocks_support');

}

function add_coralpay_to_woocommerce_gateway_list($methods){
    $methods[] = 'WC_CoralPay_Payment_Gateway';
    return $methods;
}


function coralpay_woocommerce_blocks_support() {
    if ( class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
        require_once dirname( WC_CORALPAY_PLUGIN_FILE ) . '/includes/blocks/class-coralpay-wc-gateway-blocks-support.php';
        add_action(
            'woocommerce_blocks_payment_method_type_registration',
            function ( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {

                $payment_method_registry->register( new Coralpay_WC_Gateway_Blocks_Support() );
            }
        );
    }
}

