<?php
/**
 * Plugin Name: Copy to Clipboard Button for Elementor
 * Plugin URI:  https://github.com/sunny-hossain/copy-to-clipboard-button-for-elementor
 * Author:      Sunny Hossain
 * Author URI:  https://sunnyhossain.com
 * Description: Elementor widget to add a copy to clipboard button.
 * Version:     1.0.2
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Requires PHP: 7.4
 * Requires at least: 6.6
 * Requires Plugins: elementor
 * Text Domain: copy-to-clipboard-button-for-elementor
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

define( 'COPYTOCL_PLUGIN_VERSION', '1.0.2' );
define( 'COPYTOCL_PLUGIN_FILE', __FILE__ );
define( 'COPYTOCL_PLUGIN_URL', plugins_url( '/', COPYTOCL_PLUGIN_FILE ) );

// Register and load the widget. Only run if Elementor is active.
function copytocl_register_widget( $widgets_manager ) {
    if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
        return; // Elementor not active.
    }

    require_once __DIR__ . '/includes/class-clipboard.php';
    $widgets_manager->register( new \COPYTOCL_Widget() );
}
add_action( 'elementor/widgets/register', 'copytocl_register_widget' );

// Enqueue front-end assets.
function copytocl_enqueue_scripts() {
    wp_enqueue_script( 'clipboard' );
    wp_enqueue_script( 
        'copytocl-main',
        COPYTOCL_PLUGIN_URL . 'assets/js/main.js',
        [ 'jquery', 'clipboard' ],
        COPYTOCL_PLUGIN_VERSION,
        true
    );
}
add_action( 'wp_enqueue_scripts', 'copytocl_enqueue_scripts' );

