/**
 * Initializes ClipboardJS on elements with the class 'ctce-clipboard-button'.
 * Changes button text and styles on successful copy, then reverts after a timeout.
 * Logs success and error events to the console.
 * Requires ClipboardJS library to be included in the project.
 * 
 * Version: 1.0.2
 * Author: Sunny Hossain
 * Website: https://sunnyhossain.com
 * Since: October 19, 2025
 * License: GNU General Public License v2 or later
 * Copyright: 2025 Sunny Hossain
 * 
 */

document.addEventListener('DOMContentLoaded', function () {
    var clipboard = new ClipboardJS('.ctce-clipboard-button');

    clipboard.on('success', function(e) {
        var widget = e.trigger.closest('.ctce-clipboard-content');
        if (!widget) return;

        var btnText = widget.dataset.btnText;
        var btnTextColor = widget.dataset.btnTextColor;
        var btnBgColor = widget.dataset.btnBgColor;
        var btnTextAfter = widget.dataset.btnTextAfter;
        var btnBgAfter = widget.dataset.btnBgAfter;
        var btnResetTime = widget.dataset.btnResetTime;

        var button = e.trigger;
        button.textContent = btnTextAfter;
        button.style.backgroundColor = btnBgAfter;
        button.style.color = btnTextColor;

        setTimeout(function () {
            button.textContent = btnText;
            button.style.backgroundColor = btnBgColor;
            button.style.color = btnTextColor;
        }, btnResetTime);

        console.log("Successfully copied (Widget ID: " + widget.dataset.id + "):", e.text);
        e.clearSelection();
    });

    clipboard.on('error', function(e) {
        console.error('Action:', e.action);
        console.error('Trigger:', e.trigger);
    });
});
