jQuery(document).ready(function($) {
        var dmukCppNonce = dmukCppVars.nonce;
        
        $('a.dmuk-cpp-copy-page-link, a.dmuk-cpp-copy-post-link').on('click', function(e) {
            e.preventDefault();
            var triggerElement = this;
            var postID = $(this).closest('tr').attr('id').replace('post-', '');
            var postType = $(this).hasClass('dmuk-cpp-copy-page-link') ? 'page' : 'post';

            $.post(ajaxurl, {
                action: 'dmuk_cpp_show_copy_form',
                post_id: postID,
                post_type: postType,
                dmuk_cpp_nonce: dmukCppNonce
            }, function(response) {
                if (response.success) {
                    var modalHtml = `
                        <div class="dmuk-cpp-modal-overlay" aria-hidden="true">
                            <div class="dmuk-cpp-modal" role="dialog" aria-labelledby="dmuk-cpp-modal-title">
                                <h2 id="dmuk-cpp-modal-title">Copy ${response.data.type} Content</h2>
                                <p><strong>Existing ${response.data.type} Name:</strong> ${response.data.existing_name}</p>
                                <p><strong>Suggested New Name:</strong> ${response.data.new_name}</p>
                                <p><strong>Have you backed up your database? It is recommended!</strong></p>
                                <form id="dmuk-cpp-copy-form">
                                    <label for="new_name">New ${response.data.type} Name:</label>
                                    <input type="text" id="new_name" name="new_name" value="${response.data.new_name}" required />
                                    <input type="hidden" name="dmuk_cpp_nonce" value="${dmukCppNonce}">
                                    <div style="margin-top: 10px;">
                                        <label>
                                            <input type="checkbox" id="copy_to_new_post" name="copy_to_new_post" />
                                            Copy this <span id="copy-type-label">Page</span> to a <strong><span id="new-type-label">NEW POST</span></strong>
                                        </label>
                                    </div>
                                    <div class="dmuk-cpp-button-group" style="margin-top: 15px;">
                                        <button type="submit" class="button button-primary dmuk-cpp-copy-button">Copy ${response.data.type}</button>
                                        <button type="button" class="button dmuk-cpp-cancel-button">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    `;
                    $('body').append(modalHtml);

                    if (postType === 'page') {
                        $('#copy-type-label').text('Page');
                        $('#new-type-label').text('NEW POST');
                    } else {
                        $('#copy-type-label').text('Post');
                        $('#new-type-label').text('NEW PAGE');
                    }

                    var $modalOverlay = $('.dmuk-cpp-modal-overlay');
                    var $modal = $('.dmuk-cpp-modal');
                    var $inputField = $('#new_name');

                    $modalOverlay.attr('aria-hidden', 'false');
                    $inputField.focus();

                    $('#dmuk-cpp-copy-form').on('submit', function(e) {
                        e.preventDefault();
                        $.post(ajaxurl, {
                            action: 'dmuk_cpp_copy',
                            post_id: postID,
                            new_name: $inputField.val(),
                            post_type: postType,
                            copy_to_new_post: $('#copy_to_new_post').is(':checked') ? 1 : 0,
                            dmuk_cpp_nonce: dmukCppNonce
                        }, function(copyResponse) {
                            $modalOverlay.fadeOut('fast', function() {
                                $(this).remove();
                                if (copyResponse.success) {
                                    alert(copyResponse.data.message);
                                } else {
                                    alert(copyResponse.data.message || 'An error occurred.');
                                }
                                $(triggerElement).focus();
                            });
                        }, 'json');
                    });

                    $('.dmuk-cpp-cancel-button').on('click', function() {
                        $modalOverlay.fadeOut('fast', function() {
                            $(this).remove();
                            $(triggerElement).focus();
                        });
                    });
                } else {
                    alert('Error fetching details. Please try again.');
                }
            }, 'json');
        });
    });