<?php
// File Name: dmuk-cpp-common-functions.php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Function to copy a page
function dmuk_cpp_copy_page($post_id, $new_name) {
    if (!current_user_can('edit_pages')) {
        return false; // Security check
    }
    
    $original_post = get_post($post_id);
    if (!$original_post || $original_post->post_type !== 'page') {
        return false;
    }

    $new_post = [
        'post_title'   => sanitize_text_field($new_name),
        'post_content' => $original_post->post_content,
        'post_status'  => 'draft',
        'post_author'  => $original_post->post_author,
        'post_type'    => 'page',
        'page_template' => get_page_template_slug($post_id),
    ];
    
    $new_post_id = wp_insert_post($new_post);
    if (is_wp_error($new_post_id) || !$new_post_id) {
        return false;
    }

    dmuk_cpp_copy_post_extras($post_id, $new_post_id);
    return $new_post_id;
}

// Function to copy a post
function dmuk_cpp_copy_post($post_id, $new_name) {
    if (!current_user_can('edit_posts')) {
        return false;
    }

    $original_post = get_post($post_id);
    if (!$original_post || $original_post->post_type !== 'post') {
        return false;
    }

    $new_post = [
        'post_title'   => sanitize_text_field($new_name),
        'post_content' => $original_post->post_content,
        'post_status'  => 'draft',
        'post_author'  => $original_post->post_author,
        'post_type'    => 'post',
    ];

    $new_post_id = wp_insert_post($new_post);
    if (is_wp_error($new_post_id) || !$new_post_id) {
        return false;
    }

    dmuk_cpp_copy_post_extras($post_id, $new_post_id);
    return $new_post_id;
}

// Function to copy post extras (featured image, meta fields, taxonomies)
function dmuk_cpp_copy_post_extras($post_id, $new_post_id) {
    if (has_post_thumbnail($post_id)) {
        set_post_thumbnail($new_post_id, get_post_thumbnail_id($post_id));
    }
    
    // Copy meta fields efficiently
    $meta_fields = get_post_meta($post_id);
    foreach ($meta_fields as $key => $values) {
        foreach ($values as $value) {
            update_post_meta($new_post_id, $key, $value);
        }
    }

    // Copy taxonomies
    $taxonomies = get_object_taxonomies(get_post_type($post_id));
    foreach ($taxonomies as $taxonomy) {
        $terms = wp_get_object_terms($post_id, $taxonomy, ['fields' => 'ids']);
        if (!is_wp_error($terms) && !empty($terms)) {
            wp_set_object_terms($new_post_id, $terms, $taxonomy);
        }
    }
}

// Function to copy a page to a post
function dmuk_cpp_copy_page_to_post($post_id, $new_name) {
    if (!current_user_can('edit_posts')) {
        return false;
    }

    $original_post = get_post($post_id);
    if (!$original_post || $original_post->post_type !== 'page') {
        return false;
    }

    $new_post = [
        'post_title'   => sanitize_text_field($new_name),
        'post_content' => $original_post->post_content,
        'post_status'  => 'draft',
        'post_author'  => $original_post->post_author,
        'post_type'    => 'post',
    ];

    $new_post_id = wp_insert_post($new_post);
    if (is_wp_error($new_post_id) || !$new_post_id) {
        return false;
    }

    dmuk_cpp_copy_post_extras($post_id, $new_post_id);
    return $new_post_id;
}

// Function to copy a post to a page
function dmuk_cpp_copy_post_to_page($post_id, $new_name) {
    if (!current_user_can('edit_pages')) {
        return false;
    }

    $original_post = get_post($post_id);
    if (!$original_post || $original_post->post_type !== 'post') {
        return false;
    }

    $new_post = [
        'post_title'   => sanitize_text_field($new_name),
        'post_content' => $original_post->post_content,
        'post_status'  => 'draft',
        'post_author'  => $original_post->post_author,
        'post_type'    => 'page',
    ];

    $new_post_id = wp_insert_post($new_post);
    if (is_wp_error($new_post_id) || !$new_post_id) {
        return false;
    }

    dmuk_cpp_copy_post_extras($post_id, $new_post_id);
    return $new_post_id;
}
