<?php
/**
 * Cool Payment Gateway Discounts for WooCommerce Settings
 *
 * @package Cool Payment Gateway Discounts for WooCommerce
 * @version 1.0.0
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Settings;

use Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Settings\CoolSettingWoo;

defined( 'ABSPATH' ) || exit;

/**
 * A main class that holds all our settings logic
 */
class Setting extends CoolSettingWoo {
	/**
	 * Get Tab ID.
	 *
	 * @since 0.0.1
	 * @return string Tab ID.
	 */
	protected function get_tab_id() {
		return 'cool_payment_gateway_discounts_for_woo_options';
	}

	/**
	 * Get Tab Name.
	 *
	 * @since 0.0.1
	 * @return string Tab Name.
	 */
	protected function get_tab_name() {
		return __( 'Cool Payment Gateway Discounts for WooCommerce', 'cool-payment-gateway-discounts-for-woo' );
	}

	/**
	 * Get Woo Section.
	 *
	 * @since 0.0.1
	 * @return string Woo Section.
	 */
	protected function get_woo_section() {
		return 'checkout';
	}

	/**
	 * Run After Save.
	 *
	 * @since 0.0.1
	 */
	protected function run_after_save() {
		// Do Nothing.
	}

	/**
	 * Get Setting Data.
	 *
	 * @since 0.0.1
	 * @return array Setting Data.
	 */
	protected function get_setting_data() {

		$gateways = WC()->payment_gateways->payment_gateways();

		$settings   = array();
		$settings[] = array(
			'title' => __( 'Cool Payment Gateway Discounts for WooCommerce', 'cool-payment-gateway-discounts-for-woo' ),
			'desc'  => __( 'En esta sección podrás activar y configurar el descuento por cada gateway de pago.', 'cool-payment-gateway-discounts-for-woo' ),
			'type'  => 'title',
			'id'    => 'cool_payment_gateway_discounts_for_woo_options',
		);

		$settings[] = array(
			'type' => 'sectionend',
			'id'   => 'cool_payment_gateway_discounts_for_woo_options',
		);

		foreach ( $gateways as $id => $gateway ) {

			$settings[] = array(
				'title' => esc_html( $gateway->method_title ),
				/* translators: %s: payment gateway title */
				'desc'  => sprintf( __( 'En esta sección podrás activar y configurar el descuento para el gateway de pago %s.', 'cool-payment-gateway-discounts-for-woo' ), esc_html( $gateway->method_title ) ),
				'type'  => 'title',
				'id'    => 'cool_payment_gateway_discounts_for_woo_options_' . $id,
			);
			$settings[] = array(
				'title'             => __( 'Descuento', 'cool-payment-gateway-discounts-for-woo' ),
				'desc'              => __( 'Ingrese el descuento en porcentaje.', 'cool-payment-gateway-discounts-for-woo' ),
				'id'                => 'cool_payment_gateway_discounts_for_woo_' . $id . '_discount',
				'type'              => 'number',
				'custom_attributes' => array(
					'min'  => '0',
					'max'  => '100',
					'step' => '0.01',
				),
				'default'           => 0,
			);
			$settings[] = array(
				'title'   => __( 'Texto del descuento', 'cool-payment-gateway-discounts-for-woo' ),
				'desc'    => __( 'Ingrese el texto del descuento que se mostrará en el carrito.', 'cool-payment-gateway-discounts-for-woo' ),
				'id'      => 'cool_payment_gateway_discounts_for_woo_' . $id . '_discount_text',
				'type'    => 'text',
				'default' => 'Descuento de ' . $gateway->title,
			);
			$settings[] = array(
				'type' => 'sectionend',
				'id'   => 'cool_payment_gateway_discounts_for_woo_options_' . $id,
			);
		}

		return $settings;
	}
}
