<?php
/**
 * Cool Setting Woo - base class to Woo Setting tab page
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Settings;

defined( 'ABSPATH' ) || exit;

/**
 * A main class that holds all our settings logic
 */
abstract class CoolSettingWoo {

	/**
	 * Get Tab Setting Identifier.
	 *
	 * @since 0.0.1
	 * @return string Tab Setting Identifier.
	 */
	abstract protected function get_tab_id();

	/**
	 * Get Tab Name.
	 *
	 * @since 0.0.1
	 * @return string Tab Name to be displayed.
	 */
	abstract protected function get_tab_name();

	/**
	 * Get WooCommerce Section Name.
	 *
	 * @since 0.0.1
	 * @return string WooCommerce Section Name.
	 */
	abstract protected function get_woo_section();

	/**
	 * Get Setting Data.
	 *
	 * @since 0.0.1
	 * @return array Setting Data.
	 */
	abstract protected function get_setting_data();

	/**
	 * Run After Save.
	 *
	 * @since 0.0.1
	 */
	abstract protected function run_after_save();

	/**
	 * Constructor.
	 *
	 * @since 0.0.1
	 */
	public function __construct() {
		add_filter( 'woocommerce_get_sections_' . $this->get_woo_section(), array( $this, 'add_tab_settings' ) );
		add_filter( 'woocommerce_get_settings_' . $this->get_woo_section(), array( $this, 'get_tab_settings' ), 10, 2 );
		add_action( 'woocommerce_settings_save_' . $this->get_woo_section(), array( $this, 'save' ) );
	}

	/**
	 * Add Plugin Setting Tab
	 *
	 * @param array $settings_tab Products Settings.
	 * @return array $setting_tab Products Settings.
	 */
	public function add_tab_settings( $settings_tab ) {
		$settings_tab[ $this->get_tab_id() ] = $this->get_tab_name();
		return $settings_tab;
	}

	/**
	 * Get Plugin Setting Tab
	 *
	 * @param array  $settings Products Settings.
	 * @param string $current_section Section which is beaing processing.
	 * @return array Shipping Method Settings.
	 */
	public function get_tab_settings( $settings, $current_section ) {
		if ( $this->get_tab_id() === $current_section ) {
			return $this->get_setting_data();
		} else {
			return $settings;
		}
	}

	/**
	 * Get Plugin Settings
	 *
	 * @return array Settings.
	 */
	public function get_settings() {

		/**
		 * Plugin Settings Filter.
		 *
		 * @since 0.0.1
		 *
		 * @param array $args {
		 *     List of settings fields.
		 * }
		 * @return array
		 */
		return apply_filters( 'wc_settings_' . $this->get_tab_id(), $this->get_setting_data() );
	}

	/**
	 * Update Plugin Settings
	 *
	 * @return void
	 */
	public function update_settings() {
		woocommerce_update_options( $this->get_settings() );
	}

	/**
	 * Save Plugin Settings - Execute validations
	 *
	 * @return void
	 */
	public function save() {
		woocommerce_update_options( $this->get_settings() );
		global $current_section;
		if ( $current_section === $this->get_tab_id() ) {
			$this->run_after_save();
		}
	}
}
