<?php
/**
 * Cool Setting Field Woo - base class to Woo Setting Field
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Settings;

defined( 'ABSPATH' ) || exit;

/**
 * A main class that holds all our settings logic
 */
abstract class CoolSettingFieldWoo {

	/**
	 * Get Setting Field Identifier.
	 *
	 * @since 0.0.1
	 * @return string Setting Field Identifier.
	 */
	abstract protected function get_field_id();

	/**
	 * Get Field Render.
	 *
	 * @since 0.0.1
	 * @param array $value Values from field.
	 * @return void
	 */
	abstract protected function render( $value );

	/**
	 * Constructor.
	 *
	 * @since 0.0.1
	 */
	public function __construct() {
		add_action(
			'woocommerce_admin_field_' . $this->get_field_id(),
			function ( $value ) {
				$this->render( $value );
			}
		);
	}
}
