<?php
/**
 * Cool Connect Google Field - base class to Connect Google Field
 *
 * @package  Manca\CoolGsheetWoo\Dependencies\Manca\Coolwplib\Helper
 */

namespace Manca\CoolGsheetWoo\Dependencies\Manca\Coolwplib\Settings;

defined( 'ABSPATH' ) || exit;

/**
 * A main class that holds all our settings logic
 */
class CoolConnectGoogleField extends CoolSettingFieldWoo {

	/**
	 * Get Setting Field Identifier.
	 *
	 * @since 0.0.1
	 * @return string Setting Field Identifier.
	 */
	protected function get_field_id() {
		return 'cool_connect_google';
	}

	/**
	 * Get Field Render.
	 *
	 * @since 0.0.1
	 * @param array $value Values from field.
	 * @return void
	 */
	protected function render( $value ) {
		$option_id = esc_attr( $value['id'] );
		$href      = esc_url( $value['href'] );
		$name      = esc_html( $value['name'] );
		$descr     = esc_html( $value['descr'] );
		?>
		<tr valign="top">
			<th scope="row" class="titledesc">               
			</th>
			<td class="forminp forminp-text">
				<a class="button primary" href="<?php echo esc_url( $href ); ?>" id="<?php echo esc_attr( $option_id ); ?>"><?php echo esc_html( $name ); ?><span></span></a>
				<?php
				if ( ! empty( $descr ) ) {
					?>
				<p><?php echo esc_html( $descr ); ?></p>
				<?php } ?>
			</td>
		</tr>		       
		<?php
	}

	/**
	 * Constructor.
	 *
	 * @since 0.0.1
	 */
	public function __construct() {
		parent::__construct();
	}
}
