<?php
/**
 * Cool SDK - base class to Cool Sdks
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\SDK;

defined( 'ABSPATH' ) || exit;

/**
 * Cool SDK Class
 */
abstract class CoolSdk {

	/**
	 * Get Base URL for API
	 *
	 * @since 0.0.1
	 * @return string
	 */
	abstract protected function get_base_url();

	/**
	 * Set Default Headers
	 *
	 * @since 0.0.1
	 * @return array Headers.
	 */
	protected function set_default_headers() {
		$args            = array();
		$args['timeout'] = 10;
		return $args;
	}

	/**
	 * Get Cool WC Logger
	 *
	 * @since 0.0.1
	 * @return bool|CoolWCLogger.
	 */
	protected function get_wc_logger() {
		return false;
	}

	/**
	 * Log.
	 *
	 * @since 0.0.1
	 * @param string $somethingToLog Message to log.
	 */
	protected function log( $somethingToLog = '' ) {
		if ( $this->get_wc_logger() ) {
			$this->get_wc_logger()->log_debug( $somethingToLog );
		}
	}

	/**
	 * Execute Request
	 *
	 * @since 0.0.1
	 * @param string $url Set URL for send the request to.
	 * @param array  $args Array of arguments for Request.
	 * @param bool   $log_response Determine if response should be logged or not.
	 *
	 * @return array
	 */
	protected function exec_request( $url = '', $args = array(), $log_response = true ) {

		$args = array_merge( $this->set_default_headers(), $args );

		$this->log( str_repeat( '-', 40 ) );
		$this->log( $url );

		$this->log( 'Request > ' );
		foreach ( $args as $key => $data ) {
			$this->log( $key . ':' );
			$this->log( $data );
		}

		$request = wp_safe_remote_request( $url, $args );

		if ( is_wp_error( $request ) ) {
			$this->log( 'ERROR' );
			$this->log( $request );
			return false;
		}

		$response = wp_remote_retrieve_body( $request );
		if ( $log_response ) {
			$this->log( 'Response > ' );
			$this->log( $response );
		}

		return $response;
	}
}
