<?php
/**
 * Cool WC Admin Notice - Helper to show admin notices
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper;

defined( 'ABSPATH' ) || exit;

/**
 * Cool WooCommerce Admin Notice.
 */
class CoolWCAdminNotice extends CoolAdminNotice {

	/**
	 * WooCommerce Setting Section Name.
	 *
	 * @since 0.0.6
	 * @var string $section WooCommerce Setting Section Name.
	 */
	protected string $section;

	/**
	 * Constructor.
	 *
	 * @since 0.0.6
	 * @param string $section WooCommerce Section Name.
	 * @param string $message Message to be displayed.
	 * @param string $type Type of Message.
	 */
	public function __construct( $section, $message, $type = 'error' ) {
		$this->section = $section;
		global $current_section;
		if ( $current_section === $this->section ) {
			parent::__construct( $message, $type );
		}
	}
}
