<?php
/**
 * Cool WC Custom Parameter Product - Helper to add custom parameter to WC Product searchs
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper;

defined( 'ABSPATH' ) || exit;

/**
 * Cool WooCommerce Adding Custom parameter to Product search.
 */
abstract class CoolWCAddingCustomParameterProducts {

	/**
	 * Get Custom Parameter Key Name.
	 *
	 * @since 0.0.1
	 * @return string Parameter Key Name.
	 */
	abstract protected function get_custom_parameter();

	/**
	 * Constructor.
	 *
	 * @since 0.0.1
	 */
	public function __construct() {
		add_filter(
			'woocommerce_product_data_store_cpt_get_products_query',
			function ( $query, $query_vars ) {
				$meta_key = $this->get_custom_parameter();
				if ( ! empty( $query_vars[ $meta_key ] ) ) {
					$query['meta_query'][] = array(
						'key'   => $meta_key,
						'value' => esc_attr( $query_vars[ $meta_key ] ),
					);
				}
				return $query;
			},
			10,
			2
		);
	}
}
