<?php
/**
 * Cool Admin Notice - Helper to show admin notices
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Helper;

defined( 'ABSPATH' ) || exit;

/**
 * Cool Admin Notice.
 */
class CoolAdminNotice {

	/**
	 * Message to be displayed in admin.
	 *
	 * @since 0.0.7
	 * @var string $message Message to be displayed.
	 */
	protected string $message;

	/**
	 * Message Type to be displayed.
	 *
	 * @since 0.0.7
	 * @var string $type Type of message to be displayed.
	 */
	protected string $type;

	/**
	 * Initialize class.
	 *
	 * @since 0.0.7
	 * @param string $message Message to be displayed.
	 * @param string $type Type of message to be displayed.
	 */
	public function __construct( string $message, $type = 'error' ) {
		$this->message = $message;
		$this->type    = $type;

		add_action( 'admin_notices', array( $this, 'render' ) );
	}

	/**
	 * Displays warning on the admin screen.
	 *
	 * @return void
	 */
	public function render() {
		printf( '<div class="notice notice-%s is-dismissible"><p>%s</p></div>', esc_attr( $this->type ), esc_html( $this->message ) );
	}
}
