<?php
/**
 * Cool Plugin Woo - base class for Cool WooCommerce Plugins
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base;

defined( 'ABSPATH' ) || exit;

use Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base\CoolPlugin;
/**
 * Plugin's base Class
 */
abstract class CoolPluginWoo extends CoolPlugin {

	/**
	 * Inits our plugin
	 *
	 * @return void
	 */
	public function init() {

		parent::init();

		// --- HPOS WooCommerce Compatibility
		add_action(
			'before_woocommerce_init',
			function () {
				if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
					\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', $this->get_file(), true );
				}
			}
		);
	}
}
