<?php
/**
 * Cool Plugin - base class for Cool Plugins
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base;

defined( 'ABSPATH' ) || exit;

/**
 * Plugin's base Class
 */
abstract class CoolPlugin {

	/**
	 * Get Class Name.
	 *
	 * @since 0.0.1
	 * @return string Class Name.
	 */
	abstract protected function get_class_name();

	/**
	 * Base NameSpace.
	 *
	 * @since 0.0.1
	 * @return string Namespace.
	 */
	abstract protected function get_base_namespace();

	/**
	 * Get Plugin Directory Path.
	 *
	 * @since 0.0.1
	 * @return string Path.
	 */
	abstract protected function get_dir_path();

	/**
	 * Get Text Domain.
	 *
	 * @since 0.0.1
	 * @return string Plugin Text Domain.
	 */
	abstract protected function get_text_domain();

	/**
	 * Get Current Version.
	 *
	 * @since 0.0.1
	 * @return string Version.
	 */
	abstract protected function get_current_version();

	/**
	 * Get File Constant.
	 *
	 * @since 0.0.1
	 * @return string __FILE__.
	 */
	abstract protected function get_file();

	/**
	 * Get Dependencies Prefix.
	 *
	 * @return string Dependencies Prefix.
	 * @since 1.0.1
	 */
	protected function get_dependencies_namespace_prefix() {
		return $this->get_base_namespace() . 'Dependencies\\';
	}

	/**
	 * Constructor.
	 *
	 * @since 0.0.1
	 */
	public function __construct() {
		add_action(
			'plugins_loaded',
			function () {
				$this->init();
			}
		);
	}

	/**
	 * Inits our plugin
	 *
	 * @since 0.0.1
	 */
	public function init() {

		spl_autoload_register(
			function ( $require_class ) {
				// Plugin base Namespace.
				if ( strpos( $require_class, $this->get_base_namespace() ) === false
					&& strpos( $require_class, $this->get_class_name() ) === false
					) {
					return;
				}
				if ( $this->get_class_name() === $require_class ) {
					return;
				}

				if ( strpos( $require_class, $this->get_dependencies_namespace_prefix() ) !== false ) {
					$require_class = str_replace( $this->get_dependencies_namespace_prefix(), '', $require_class );
					$require_class = str_replace( '\\', '/', $require_class );
					$filepath      = $this->get_dir_path() . '/inc/' . $require_class . '.php';
				} else {
					$require_class = str_replace( '\\', '/', $require_class );
					$parts         = explode( '/', $require_class );
					$classname     = array_pop( $parts );

					$filename = $classname;
					$filename = str_replace( 'WooCommerce', 'Woocommerce', $filename );
					$filename = str_replace( 'WC_', 'Wc', $filename );
					$filename = str_replace( 'WC', 'Wc', $filename );
					$filename = preg_replace( '/([A-Z])/', '-$1', $filename );
					$filename = 'class' . $filename;
					$filename = strtolower( $filename );
					$folder   = strtolower( array_pop( $parts ) );

					$filepath = $this->get_dir_path() . '/src/' . $folder . '/' . $filename . '.php';
				}

				if ( file_exists( $filepath ) ) {
					require_once $filepath;
				}
			}
		);
		self::load_textdomain( $this->get_text_domain() );
		return true;
	}

	/**
	 * Loads the plugin text domain
	 *
	 * @param string $textdomain Plugin text domain.
	 *  @since 0.0.1
	 */
	public function load_textdomain( $textdomain = '' ) {
		if ( $textdomain ) {
			load_plugin_textdomain( $textdomain, false, $this->get_dir_path() . '/i18n/languages' );
		}
	}
}
