<?php
/**
 * Cool Base Subpage - base class for subpages
 *
 * @package  Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base
 */

namespace Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base;

defined( 'ABSPATH' ) || exit;

/**
 * Cool Base Subpage
 */
abstract class CoolBaseSubpage {

	/**
	 * Get Page Name.
	 *
	 * @since 0.0.1
	 * @return string Page Name.
	 */
	abstract protected function get_page_name();

	/**
	 * Get Page Slug.
	 *
	 * @since 0.0.1
	 * @return string Page Slug.
	 */
	abstract protected function get_page_slug();

	/**
	 * Get Page Title.
	 *
	 * @since 0.0.1
	 * @return string Page Title.
	 */
	abstract protected function get_page_title();

	/**
	 * Get Parent Slug.
	 *
	 * @since 0.0.1
	 * @return string Parent Slug.
	 */
	abstract protected function get_parent_slug();

	/**
	 * Get Capabilities to access page.
	 *
	 * @since 0.0.1
	 * @return string Capabilities.
	 */
	abstract protected function get_capabilities();

	/**
	 * Render Subpage.
	 *
	 * @since 0.0.1
	 */
	abstract protected function render();

	/**
	 * Constructor.
	 *
	 * @since 0.0.1
	 */
	public function __construct() {
		add_action(
			'admin_menu',
			function () {
				add_submenu_page(
					$this->get_parent_slug(),
					$this->get_page_name(),
					$this->get_page_title(),
					$this->get_capabilities(),
					$this->get_page_slug(),
					function () {
						$this->main_render();
					}
				);
			}
		);
	}

	/**
	 * Render Main Subpage structure.
	 *
	 * @since 0.0.1
	 */
	protected function main_render() {
		?>
		<div class="wrap">
			<h1><?php echo esc_html( $this->get_page_title() ); ?></h1>
			<?php $this->render(); ?>
		</div>
		<?php
	}
}
