<?php
/**
 * Plugin Name: Cool Payment Gateway Discounts for Woo
 * Description: Set discounts for each Payment Gateway on WooCommerce.
 * Version: 1.0.1
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 * Author: matiasanca
 * Author URI: https://manca.com.ar
 * Text Domain: cool-payment-gateway-discounts-for-woo
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package Manca\CoolPaymentGatewayDiscountsForWoo;
 */

defined( 'ABSPATH' ) || exit;

require __DIR__ . '/inc/Manca/Coolwplib/Base/CoolPlugin.php';
require __DIR__ . '/inc/Manca/Coolwplib/Base/CoolPluginWoo.php';

use Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base\CoolPlugin;
use Manca\CoolPaymentGatewayDiscountsForWoo\Dependencies\Manca\Coolwplib\Base\CoolPluginWoo;

use Manca\CoolPaymentGatewayDiscountsForWoo\Settings\Setting;
use Manca\CoolPaymentGatewayDiscountsForWoo\Cart\Discount;

/**
 * Plugin's base Class
 */
class CoolPaymentGatewayDiscountsForWoo extends CoolPlugin {

	/**
	 * Plugin Name.
	 *
	 * @since 0.0.1
	 * @return string Name.
	 */
	public static function get_plugin_name() {
		return plugin_basename( __FILE__ );
	}

	/**
	 * Get Class Name.
	 *
	 * @since 0.0.1
	 * @return string Class Name.
	 */
	protected function get_class_name() {
		return __CLASS__;
	}

	/**
	 * Base NameSpace.
	 *
	 * @since 0.0.1
	 * @return string Namespace.
	 */
	protected function get_base_namespace() {
		return 'Manca\\CoolPaymentGatewayDiscountsForWoo\\';
	}

	/**
	 * Get Plugin Directory Path.
	 *
	 * @since 0.0.1
	 * @return string Path.
	 */
	protected function get_dir_path() {
		return __DIR__;
	}

	/**
	 * Get Text Domain.
	 *
	 * @since 0.0.1
	 * @return string Plugin Text Domain.
	 */
	protected function get_text_domain() {
		return 'cool-payment-gateway-discounts-for-woo';
	}

	/**
	 * Get Current Version.
	 *
	 * @since 0.0.1
	 * @return string Version.
	 */
	protected function get_current_version() {
		return '1.0.1';
	}

	/**
	 * Get File Constant.
	 *
	 * @since 0.0.1
	 * @return string __FILE__.
	 */
	protected function get_file() {
		return __FILE__;
	}

	/**
	 * Inits our plugin
	 *
	 * @since 0.0.1
	 */
	public function init() { // phpcs:ignore Generic.CodeAnalysis.UselessOverridingMethod.Found
		parent::init();
		// Add some functionality here.
		add_filter( 'plugin_action_links_' . self::get_plugin_name(), array( $this, 'create_setting_link' ) );
		add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'register_frontend_scripts' ) );
		new Setting();
		new Discount();
	}

	/**
	 * Add menu item under WooCommerce
	 *
	 * @since 1.0.0
	 */
	public function add_admin_menu() {
		add_submenu_page(
			'woocommerce',
			__( 'Payment Gateway Discounts', 'cool-payment-gateway-discounts-for-woo' ),
			__( 'Payment Gateway Discounts', 'cool-payment-gateway-discounts-for-woo' ),
			'manage_woocommerce',
			'admin.php?page=wc-settings&tab=checkout&section=cool_payment_gateway_discounts_for_woo_options',
			''
		);
	}

	/**
	 * Create Setting Link.
	 *
	 * @since 0.0.1
	 * @param array $links Links.
	 * @return array Links.
	 */
	public function create_setting_link( $links ) {
		$settings_link = '<a href="admin.php?page=wc-settings&tab=checkout&section=cool_payment_gateway_discounts_for_woo_options">' . __( 'Settings', 'cool-payment-gateway-discounts-for-woo' ) . '</a>';
		array_unshift( $links, $settings_link );
		return $links;
	}

	/**
	 * Register frontend scripts.
	 *
	 * @since 0.0.1
	 */
	public function register_frontend_scripts() {
		wp_register_script( 'cool-payment-gateway-discounts-for-woo-checkout', plugins_url( 'assets/js/checkout.js', self::get_plugin_name() ), array( 'jquery' ), $this->get_current_version(), true );
	}
}

new CoolPaymentGatewayDiscountsForWoo();
