<?php
/**
 * Plugin Name: Cookifi – GDPR/CCPA Compliant Cookie Banner with Consent Mode & Geo Targeting
 * Plugin URI: https://cooki.fi
 * Description: Integrate Cookifi Consent Management Platform into your WordPress site. Easily comply with GDPR, CCPA, and other privacy regulations.
 * Version: 1.0.0
 * Author: Cookifi
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: cookifi
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('COOKIFI_VERSION', '1.0.0');
define('COOKIFI_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('COOKIFI_PLUGIN_URL', plugin_dir_url(__FILE__));
define('COOKIFI_PLUGIN_FILE', __FILE__);

// Include required files
require_once COOKIFI_PLUGIN_DIR . 'includes/class-settings.php';
require_once COOKIFI_PLUGIN_DIR . 'includes/class-script-injector.php';

// Initialize the plugin
function cookifi_cmp_init() {
    // Initialize settings
    $settings = new Cookifi_Settings();
    $settings->init();

    // Initialize script injector
    $injector = new Cookifi_Script_Injector();
    $injector->init();
}
add_action('plugins_loaded', 'cookifi_cmp_init');

// Plugin activation hook
function cookifi_cmp_activate() {
    // Set default options
    add_option('cookifi_cmp_api_key', '');
    add_option('cookifi_cmp_consent_defaults', '');
    add_option('cookifi_cmp_debug_mode', false);
    add_option('cookifi_cmp_hidden_mode', false);
}
register_activation_hook(__FILE__, 'cookifi_cmp_activate');

// Plugin deactivation hook
function cookifi_cmp_deactivate() {
    // Cleanup if needed
}
register_deactivation_hook(__FILE__, 'cookifi_cmp_deactivate');

// Uninstall hook
function cookifi_cmp_uninstall() {
    // Remove options
    delete_option('cookifi_cmp_api_key');
    delete_option('cookifi_cmp_consent_defaults');
    delete_option('cookifi_cmp_debug_mode');
    delete_option('cookifi_cmp_hidden_mode');
}
register_uninstall_hook(__FILE__, 'cookifi_cmp_uninstall');

// Add settings link on plugins page
function cookifi_cmp_add_settings_link($links) {
    $settings_link = '<a href="options-general.php?page=cookifi">' . __('Settings', 'cookifi') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'cookifi_cmp_add_settings_link');
