<?php
/**
 * Admin settings page template
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap cookifi-settings">
    <div class="cookifi-header">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    </div>

    <div class="cookifi-content">
        <div class="cookifi-main">
            <div class="cookifi-card">
                <form action="options.php" method="post">
                    <?php
                    settings_fields('cookifi_cmp_settings');
                    do_settings_sections('cookifi');
                    submit_button(__('Save Settings', 'cookifi'));
                    ?>
                </form>
            </div>

            <?php
            $cookifi_api_key = get_option('cookifi_cmp_api_key', '');
            $cookifi_consent_defaults = get_option('cookifi_cmp_consent_defaults', '');
            $cookifi_has_consent_defaults = !empty(trim($cookifi_consent_defaults));

            if (!empty($cookifi_api_key)) :
            ?>
            <div class="cookifi-card cookifi-status">
                <h2><?php esc_html_e('Status', 'cookifi'); ?></h2>

                <!-- CMP Script Status -->
                <div class="cookifi-status-item">
                    <span class="cookifi-status-icon cookifi-status-active">✓</span>
                    <span><?php esc_html_e('Cookifi script is active and will be loaded on all pages.', 'cookifi'); ?></span>
                </div>

                <!-- Consent Defaults Status -->
                <?php if ($cookifi_has_consent_defaults) : ?>
                <div class="cookifi-status-item">
                    <span class="cookifi-status-icon cookifi-status-active">✓</span>
                    <span><?php esc_html_e('Consent provider defaults are configured and will be injected before the CMP script.', 'cookifi'); ?></span>
                </div>
                <?php else : ?>
                <div class="cookifi-status-item">
                    <span class="cookifi-status-icon cookifi-status-inactive">⚠</span>
                    <span><?php esc_html_e('Consent provider defaults are not configured (optional). Configure them below if you use marketing or analytics integrations that support consent mode.', 'cookifi'); ?></span>
                </div>
                <?php endif; ?>
            </div>
            <?php else : ?>
            <div class="cookifi-card cookifi-status">
                <h2><?php esc_html_e('Status', 'cookifi'); ?></h2>
                <div class="cookifi-status-item">
                    <span class="cookifi-status-icon cookifi-status-inactive">⚠</span>
                    <span><?php esc_html_e('Cookifi is not active. Please enter your API key above.', 'cookifi'); ?></span>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <div class="cookifi-sidebar">
            <div class="cookifi-card">
                <h3><?php esc_html_e('Getting Started', 'cookifi'); ?></h3>
                <ol class="cookifi-steps">
                    <li>
                        <strong><?php esc_html_e('Create an account', 'cookifi'); ?></strong>
                        <p>
                            <?php
                            /* translators: %s: URL to admin.cooki.fi */
                            printf(
                                esc_html__('Visit ', 'cookifi') . '<a href="%s" target="_blank">admin.cooki.fi</a>' . esc_html__(' to create your account.', 'cookifi'),
                                esc_url('https://admin.cooki.fi')
                            );
                            ?>
                        </p>
                    </li>
                    <li>
                        <strong><?php esc_html_e('Get your API Key', 'cookifi'); ?></strong>
                        <p><?php esc_html_e('After creating your account, you\'ll receive an API key for your website.', 'cookifi'); ?></p>
                    </li>
                    <li>
                        <strong><?php esc_html_e('Configure the plugin', 'cookifi'); ?></strong>
                        <p>
                            <?php
                            /* translators: %s: URL link to admin.cooki.fi */
                            printf(
                                esc_html__('Log in to ', 'cookifi') . '%s' . esc_html__(' and go to your property settings. Copy your API key and paste it in the field above. If you use marketing or analytics integrations, also copy the "Consent Provider Defaults" script.', 'cookifi'),
                                '<a href="' . esc_url('https://admin.cooki.fi') . '" target="_blank">admin.cooki.fi</a>'
                            );
                            ?>
                        </p>
                    </li>
                    <li>
                        <strong><?php esc_html_e('You\'re done!', 'cookifi'); ?></strong>
                        <p><?php esc_html_e('The consent dialog will automatically appear on your website.', 'cookifi'); ?></p>
                    </li>
                </ol>
            </div>

            <div class="cookifi-card">
                <h3><?php esc_html_e('Resources', 'cookifi'); ?></h3>
                <ul class="cookifi-links">
                    <li>
                        <a href="https://cooki.fi" target="_blank">
                            <?php esc_html_e('Visit Cookifi Website', 'cookifi'); ?>
                        </a>
                    </li>
                    <li>
                        <a href="https://admin.cooki.fi" target="_blank">
                            <?php esc_html_e('Dashboard Login', 'cookifi'); ?>
                        </a>
                    </li>
                    <li>
                        <a href="https://docs.cooki.fi" target="_blank">
                            <?php esc_html_e('Documentation', 'cookifi'); ?>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="cookifi-card">
                <h3><?php esc_html_e('About Cookifi', 'cookifi'); ?></h3>
                <p><?php esc_html_e('Cookifi is a comprehensive consent management platform that helps you comply with GDPR, CCPA, and other privacy regulations.', 'cookifi'); ?></p>
                <p>
                    <strong><?php esc_html_e('Version:', 'cookifi'); ?></strong> <?php echo esc_html(COOKIFI_VERSION); ?>
                </p>
            </div>
        </div>
    </div>
</div>
