<?php

use App\Services\ViewHelper\TagManagementView;

$nds_add_meta_nonce = wp_create_nonce('nds_add_user_meta_form_nonce');
$nds_tag_nonce = wp_create_nonce('tag_action');
?>

<style>
    .row-wrap {
        display: flex;
        flex-wrap: wrap;
        justify-content: flex-start;
    }

    .mr-3 {
        margin-right: 3%;
    }

    .mbt-3 {
        margin-bottom: 3%;
    }

    .col-wrap--hidden {
        display: none;
    }

    .custom-ul {
        background-color: #fff;
        overflow: scroll;
        overflow-x: hidden;
        max-height: 130px;
        max-width: 300px;
        border: 1px solid #ccc;
        border-radius: 5px;
        padding: 5px;
        list-style: none;
        margin: 0;
        padding: 0;
    }

    .custom-ul li {
        display: flex;
        margin: 5px 0 5px 3%;
        align-items: center;
        margin-bottom: 5px;

        word-wrap: break-word;
    }

    .custom-ul input[type="checkbox"] {
        margin-right: 5px;
    }
</style>

<div class="wrap nosubsub">
    <hr class="wp-header-end">
    <h1 class="wp-heading-inline"><?php echo esc_html__(
        'Tag Edit',
        'cookie-opt'
    ); ?></h1>
    <div class="wp-clearfix">

        <form action="<?php echo esc_url(
            admin_url('admin-post.php') . '?id=' . esc_attr($data['id'])
        ); ?>" method="POST">
            <input type="hidden" name="action" value="handle_update_tag" />
            <input type="hidden" name="nds_add_user_meta_nonce" value="<?php echo esc_attr(
                $nds_add_meta_nonce
            ); ?>" />
            <input type="hidden" name="tag_action" value="<?php echo esc_attr(
                $nds_tag_nonce
            ); ?>" />
            <div class="row-wrap mbt-3">
                <div class="col-wrap mr-3">
                    <div class="form-wrap">
                        <label for="tag_id"><?php echo esc_html__(
                            'Tag Selection',
                            'cookie-opt'
                        ); ?></label>
                        <select id="tag_id" name="tag_id" class="postform" aria-describedby="parent-description">
                            <option value="null"><?php echo esc_html__(
                                'Add New Tag',
                                'cookie-opt'
                            ); ?></option>
                            <option value="<?php echo esc_html(
                                empty($data['tag_id']) ? 'null' : $data['tag_id']
                            ); ?>" hidden><?php echo esc_html(
                                 $data['tag_name']
                             ); ?></option>
                            <?php foreach ($data['all_tag'] as $tag_name): ?>
                                <option value="<?php echo esc_html(
                                    $tag_name->tagid
                                ); ?>"><?php echo esc_html(
                                     $tag_name->name
                                 ); ?></option>
                            <?php endforeach; ?>
                        </select>
                        <?php TagManagementView::messageError(
                            'tag_id',
                            'errorsForUpdate'
                        ); ?>
                    </div>
                </div>

                <div id="name" class="col-wrap <?php echo esc_attr(
                    $data['tag_id'] == null ? '' : 'col-wrap--hidden'
                ); ?> mr-3">
                    <div class="form-wrap">
                        <label for="name"><?php echo esc_html__(
                            'Name',
                            'cookie-opt'
                        ); ?></label>
                        <input name="name" type="text" placeholder="Enter Name" value="<?php echo esc_attr(
                            $data['name']
                        ); ?>">
                        <?php TagManagementView::messageError(
                            'name',
                            'errorsForUpdate'
                        ); ?>
                    </div>
                </div>

                <div id="position" class="col-wrap mr-3">
                    <div class="form-wrap">
                        <label for="position"><?php echo esc_html__(
                            'Position',
                            'cookie-opt'
                        ); ?></label>
                        <select name="position" id="parent" aria-describedby="parent-description">
                            <option value="<?php echo esc_attr(
                                $data['position']
                            ); ?>" hidden><?php echo esc_html(
                                 htmlspecialchars($data['position'] == 0 ? '<head>' : '<body>')
                             ); ?></option>
                            <option value="0">&lt;head&gt;</option>
                            <option value="1">&lt;body&gt;</option>
                        </select>
                        <?php TagManagementView::messageError(
                            'position',
                            'errorsForUpdate'
                        ); ?>
                    </div>
                </div>

                <div class="col-wrap mr-3">
                    <div class="form-wrap">
                        <label for="installation_page"><?php echo esc_html__(
                            'Installation Page',
                            'cookie-opt'
                        ); ?></label>
                        <ul class="custom-ul">
                            <li><input type="checkbox" id="all" name="installation_page[]" value="all" <?php echo esc_html(
                                in_array('all', $data['installation_page'])
                                ? 'checked '
                                : ''
                            ); ?>>
                                <label for="all">All</label>
                            </li>
                            <?php foreach ($data['all_page'] as $page): ?>
                                <li>
                                    <input id="<?php echo esc_attr(
                                        'checkbox-' . $page->ID
                                    ); ?>" type="checkbox" name="installation_page[]" value="<?php echo esc_attr(
                                         $page->ID
                                     ); ?>" <?php echo esc_html(
                                          in_array($page->ID, $data['installation_page']) ? 'checked ' : ''
                                      ); ?>>
                                    <label for="<?php echo esc_attr(
                                        'checkbox-' . $page->ID
                                    ); ?>"><?php echo esc_html(
                                         $page->post_title
                                     ); ?></label>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        <?php TagManagementView::messageError(
                            'installation_page',
                            'errorsForUpdate'
                        ); ?>
                    </div>
                </div>

                <div class="col-wrap mr-3">
                    <div class="form-wrap">
                        <label for="tag"><?php echo esc_html__(
                            'Tag',
                            'cookie-opt'
                        ); ?></label>
                        <textarea id="tag" name="tag" rows="5" style="background: white;" cols="40"
                            aria-describedby="description-description">
                            <?php
                            echo htmlspecialchars_decode($data['tag']) //phpcs:ignore WordPress.Security
                                ?>
                        </textarea>
                        <?php TagManagementView::messageError(
                            'tag',
                            'errorsForUpdate'
                        ); ?>
                    </div>
                </div>

                <div id="status" class="col-wrap">
                    <div class="form-wrap">
                        <label for="active"><?php echo esc_html__(
                            'Status',
                            'cookie-opt'
                        ); ?></label>
                        <select name="active" id="active">
                            <option value="0" <?php echo $data['active'] == 0
                                ? 'selected'
                                : ''; ?>>
                                <?php echo esc_html__(
                                    'Active',
                                    'cookie-opt'
                                ); ?>
                            </option>
                            <option value="1" <?php echo $data['active'] == 1
                                ? 'selected'
                                : ''; ?>>
                                <?php echo esc_html__(
                                    'Passive',
                                    'cookie-opt'
                                ); ?>
                            </option>
                        </select>
                        <?php TagManagementView::messageError(
                            'status',
                            'errorsForUpdate'
                        ); ?>
                    </div>
                </div>

            </div>
            <input type="submit" class="button-primary" name="submit" value="<?php echo esc_html__(
                'Update',
                'cookie-opt'
            ); ?>">
        </form>
    </div>
</div>
<?php if (get_transient('errorsForUpdate') !== false) {
    delete_transient('errorsForUpdate');
} ?>
<script type="text/javascript">
    jQuery(document).ready(function () {
        //Show data when load page
        jQuery('#tag_id').on('change', function () {
            let value = jQuery(this).val();
            if (value == "null") {
                jQuery('#name').removeClass('col-wrap--hidden');
            } else {
                jQuery('#name').addClass('col-wrap--hidden');
            }
        });

        /* ------Selection after editing-------- */

        let $checkboxes = jQuery('input[type="checkbox"]').not('#all');
        jQuery('#all').change(function () {
            let isChecked = jQuery(this).prop('checked');
            jQuery('input[type="checkbox"]').prop('checked', isChecked);
        });

        $checkboxes.change(function () {
            // Check if all checkboxes except "All" is selected
            let allChecked = $checkboxes.length === $checkboxes.filter(':checked').length;
            jQuery('#all').prop('checked', allChecked);
        });
    })
</script>