<?php

use App\Services\ViewHelper\TagManagementView;

$nds_add_meta_nonce = wp_create_nonce('nds_add_user_meta_form_nonce');
$nds_tag_nonce = wp_create_nonce('tag_action');
?>
<div class="wrap coop-tag-add-page">
    <hr class="wp-header-end">
    <h1 class="wp-heading-inline"><b><?php echo esc_html__('Tag Management Settings > Add Tag','cookie-opt') ?></b></h1>
    <div class="wp-clearfix">
        <h2><?php echo esc_html__('Add New Tag','cookie-opt') ?></h2>
        <form action="<?php echo esc_url(
            admin_url('admin-post.php')
        ); ?>" method="POST">
            <input type="hidden" name="action" value="handle_add_tag" />
            <input type="hidden" name="nds_add_user_meta_nonce" value="<?php echo esc_attr(
                $nds_add_meta_nonce
            ); ?>" />
            <input type="hidden" name="add_tag_nonce" value="<?php echo esc_attr(
                $nds_tag_nonce
            ); ?>" />
            <div class="row-wrap">
                <div class="col-wrap mr-bot-24px">
                    <div class="form-wrap">
                        <label for="tag_id"><?php echo esc_html__(
                            'Tag Selection',
                            'cookie-opt'
                        ); ?></label>
                        <select id="tag_id" name="tag_id" class="postform coop-form-select mr-bot-8px mr-top-4px coop-tag-form-border"
                            aria-describedby="parent-description">
                            <!-- <option value="" hidden>--Sellect--</option> -->
                            <option value="null" selected><?php echo esc_html__(
                                'Add New Tag',
                                'cookie-opt'
                            ); ?></option>
                            <?php foreach ($data['all_tag'] as $tag_name): ?>
                                <option value="<?php echo esc_html(
                                    $tag_name->tagid
                                ); ?>"><?php echo esc_html(
                                     $tag_name->name
                                 ); ?></option>
                            <?php endforeach; ?>
                        </select>
                        <?php TagManagementView::messageError(
                            'tag_id',
                            'errorsForCreate'
                        ); ?>
                    </div>

                    <button type="button" id="coop-add-name-tag" class="mr-top-8px coop-button coop-button__primary"><?php echo esc_html__('+Add Name','cookie-opt') ?></button>
                </div>

                <div class="col-wrap coop-tag-form-flex">
                    <div id="name_entry" class="col-wrap mr-bot-24px coop-w-36">
                        <div class="form-wrap">
                            <label for="name"><?php echo esc_html__(
                                'Name entry',
                                'cookie-opt'
                            ); ?></label>
                            <input class="coop-w-100 coop-tag-form-border" name="name" type="text" placeholder="Enter Name">
                            <?php TagManagementView::messageError(
                                'name',
                                'errorsForCreate'
                            ); ?>
                        </div>
                    </div>

                    <div id="position" class="col-wrap mr-bot-24px coop-w-36 ">
                        <div class="form-wrap coop-mr-l2">
                            <label for="position"><?php echo esc_html__(
                                'Position',
                                'cookie-opt'
                            ); ?></label>
                            <select class="coop-w-100 coop-mw-100 coop-tag-form-border" name="position" id="parent"
                                aria-describedby="parent-description">
                                <option value="-1" hidden>--Sellect--</option>
                                <option value="0">&lt;head&gt;</option>
                                <option value="1">&lt;body&gt;</option>
                            </select>
                            <?php TagManagementView::messageError(
                                'position',
                                'errorsForCreate'
                            ); ?>
                        </div>
                    </div>
                </div>


                <div class="col-wrap mr-bot-24px">
                    <div class="form-wrap">
                        <label for="installation_page"><?php echo esc_html__(
                            'Installation Page',
                            'cookie-opt'
                        ); ?></label>
                        <ul class="custom-ul coop-w-74 coop-tag-form-border">
                            <li>
                                <input type="checkbox" id="all" class="coop-mr-0" name="installation_page[]" value="all"> 
                                <label for="all">All</label> 
                            </li>
                            <?php foreach ($data['all_page'] as $page): ?>
                                <li>
                                    <input id="<?php echo esc_attr('checkbox-' . $page->ID); ?>" class="coop-mr-0" type="checkbox" name="installation_page[]" value="<?php echo esc_attr($page->ID); ?>"> 
                                    <label for="<?php echo esc_attr('checkbox-' . $page->ID); ?>"><?php echo esc_html($page->post_title); ?></label>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        <?php TagManagementView::messageError(
                            'installation_page',
                            'errorsForCreate'
                        ); ?>
                    </div>
                </div>

                <div class="col-wrap mr-bot-24px">
                    <div class="form-wrap">
                        <label for="tag"><?php echo esc_html__(
                            'Tag',
                            'cookie-opt'
                        ); ?></label>
                        <textarea class="coop-tag-form-border coop-w-74 coop-tag-bg-textarea" id="tag" name="tag" rows="5" cols="40"
                            aria-describedby="description-description"></textarea>
                        <?php TagManagementView::messageError(
                            'tag',
                            'errorsForCreate'
                        ); ?>
                    </div>
                </div>

            </div>
            <input type="submit" class="coop-button coop-button__primary" name="submit" value="<?php echo esc_html__(
                'Add',
                'cookie-opt'
            ); ?>">
        </form>
    </div>
</div>
<?php if (get_transient('errorsForCreate') !== false) {
    delete_transient('errorsForCreate');
} ?>
<script type="text/javascript">
    jQuery(document).ready(function () {

        jQuery("#custom-alert").fadeIn();

        // Close the custom alert
        jQuery("#close-alert").click(function () {
            jQuery("#custom-alert").fadeOut();
        });
        jQuery('#coop-add-name-tag').click(()=>{
            jQuery('#tag_id').val('null').change()
        })
        //show "Name entry" and "Installation position"
        jQuery('#tag_id').on('change', function () {
            let value = jQuery(this).val();
            if (value == "null") {
                jQuery('#name_entry,#position').removeClass('col-wrap--hidden');
            } else {
                jQuery('#name_entry,#position').addClass('col-wrap--hidden');
            }
        });

        /*----------- catch checkbox event ------------------------ */
        var $checkboxes = jQuery('input[type="checkbox"]').not('#all');

        jQuery('#all').change(function () {
            var isChecked = jQuery(this).prop('checked');
            jQuery('input[type="checkbox"]').prop('checked', isChecked);
        });

        $checkboxes.change(function () {
            // Check if all checkboxes except "All" is selected
            var allChecked = $checkboxes.length === $checkboxes.filter(':checked').length;
            jQuery('#all').prop('checked', allChecked);
        });
    })
</script>