<?php
$nds_add_publish_settings = wp_create_nonce('nds_add_publish_settings'); ?>
<div class="wrap coop-publish-index">
    <hr class="wp-header-end">
    <h2><?php echo esc_html__('Publish Settings', 'cookie-opt'); ?></h2>
    <div class="content">
        <form action="<?php echo esc_url(
            admin_url('admin-post.php')
        ); ?>" method="post">
            <input type="hidden" name="action" value="handle_add_publish_settings" />
            <input type="hidden" name="nds_add_publish_settings" value="<?php echo esc_attr(
                $nds_add_publish_settings
            ); ?>" />
            <div class="form-action flex-colum">
                <label>
                    <b><?php echo esc_html__('CookieOpt Key', 'cookie-opt'); ?></b>
                </label>
                <input type="text" name="cookie_opt_id" class="coop-publish-index-form-input mr-tb-1"
                    value="<?php echo esc_html(empty($data['option']) ? '' : $data['option']); ?>">
                <?php echo esc_html($this->messageError('publish_settings')); ?>
                <button class="coop-button coop-button__primary"
                    type="submit"><?php echo esc_html__('Save', 'cookie-opt'); ?></button>
            </div>
        </form>
        <form action="<?php echo esc_url(
            admin_url('admin-post.php')
        ); ?>" method="post">
            <input type="hidden" name="action" value="handle_update_package_user" />
            <input type="hidden" name="nds_add_publish_settings" value="<?php echo esc_attr(
                $nds_add_publish_settings
            ); ?>" />
            <div class="coop-card mr-b-24 coop-w-1080px">
                <div class="coop-card__header">
                    <?php echo esc_html__('Registration Information','cookie-opt') ?>
                </div>
                <div class="coop-card__body">
                    <table class="coop-table coop-table__collapse coop-publish-border">
                        <tbody class="coop-table__body ">
                            <tr>
                                <td class="coop-w-30"><?php echo esc_html__('Current Plan: ','cookie-opt'); ?></td>
                                <td class="coop-w-70"><?php echo esc_html(strtoupper($data['plan'])); ?></td>
                            </tr>
                            <tr>
                                <td class="coop-w-30"><?php echo esc_html__('Registration date: ','cookie-opt'); ?></td>
                                <td class="coop-w-70"><?php echo esc_html(strtoupper($data['created_time'])); ?></td>
                            </tr>
                            <tr>
                                <td class="coop-w-30"><?php echo esc_html__('View limit per month: ','cookie-opt'); ?></td>
                                <td class="coop-w-70"><?php echo esc_html(strtoupper($data['limit_package'])) . esc_html__(' times', 'cookie-opt'); ?></td>
                            </tr>
                            <tr>
                                <td class="coop-w-30"> <?php echo esc_html__('Remaining view: ','cookie-opt'); ?></td>
                                <td class="coop-w-70"><?php echo esc_html(strtoupper($data['remaining_amount'])) . esc_html__(' times', 'cookie-opt'); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="coop-card__footer mr-b-24">
                    <button class="coop-button coop-button__primary"><?php echo esc_html__('Update','cookie-opt') ?></button>
                </div>
            </div>
        </form>
    </div>
</div>