<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

$nds_add_other = wp_create_nonce('nds_add_other');
?>
<div class="wrap">
    <hr class="wp-header-end">
    <div class="content">
        <div class="head-content">
            <h2><?php echo esc_html__('External Collaboration', 'cookie-optimizer') ?></h2>
        </div>
        <form action="<?php echo esc_url(admin_url('admin-post.php')) ?>" method="post">
            <input type="hidden" name="action" value="hanlde_add_other" />
            <input type="hidden" name="nds_add_other" value="<?php echo esc_attr($nds_add_other) ?>" />
            <div class="form-action">
                <table class="form-publish-settings">
                    <tbody>
                        <tr>
                            <th class="w-10"><?php echo esc_html__('MedipartnerWP ID', 'cookie-optimizer') ?></th>
                            <td><input name="other" type="text" value="<?php echo esc_attr(empty($data['option']->option_value) ? '' : $data['option']->option_value) ?>"></td>
                            <?php echo esc_html($this->messageError('other')); ?>
                        </tr>
                        <tr>
                            <td></td>
                            <td><button class="button" type="submit"><?php echo esc_html__('Save', 'cookie-optimizer') ?></button></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </form>
    </div>
</div>