<div class="coop-dashboard-widget">

    <!-- info package user -->
    <div class="coop-card__group-info">
        <div class="coop-card__group-info-field">
            <p><?php echo esc_html__('Current Plan: ', 'cookie-opt') ?></p>
            <p class="field-center"><?php echo esc_html__('View limit per month: ', 'cookie-opt') ?></p>
            <p><?php echo esc_html__('Remaining view: ', 'cookie-opt') ?></p>
        </div>
        <div class="coop-card__group-info-value">
            <p><?php echo esc_attr($data['typePackage']) ?></p>
            <p class="field-center"><?php echo esc_attr($data['limit_package']) . esc_html__(' times', 'cookie-opt') ?>
            </p>
            <p><?php echo esc_attr($data['remaining_amount']) . esc_html__(' times', 'cookie-opt') ?></p>
        </div>
    </div>
    <!-- end info package user -->

    <!-- info tag -->
    <div class="coop-card__group-tag">
        <div class="coop-card__group-tag-content">
            <b>タグ管理</b>
        </div>
        <div class="coop-card__group-tag-info">
            <div class="coop-card__group-tag-info-field">
                <p><?php echo esc_html__('Managed Tags', 'cookie-opt') ?></p>
                <p><?php echo esc_html__('Total Active Tags', 'cookie-opt') ?></p>
            </div>
            <div class="coop-card__group-tag-info-value">
                <p><?php echo esc_attr($data['args']['sum_tag']) ?></p>
                <p><?php echo esc_attr($data['args']['tag_active']) ?></p>
            </div>
        </div>
    </div>
    <!-- end info tag -->

    <!-- info action banner and chart -->
    <div class="coop-card__group-chart">
        <div class="coop-card__group-chart-content">
            <b>デイリーサマリー</b>
        </div>
        <div class="coop-card__group-chart-info">
            <div class="coop-card__group-chart-info-table">
                <div
                    class="coop-row coop-card__group-chart-info-table-header coop-card__group-chart-info-table--border">
                    <p class="coop-table-w70"><?php echo esc_html__('Total view today: ', 'cookie-opt') ?></p>
                    <p class="coop-table-w30">
                        <?php echo esc_attr($data['args']['view']) . esc_html__(' times', 'cookie-opt') ?>
                    </p>
                </div>
                <div class="coop-row coop-card__group-chart-info-table--border coop-card__group-chart-info-table-row">
                    <div class="coop-table-w70 coop-row-item">
                        <div class="coop-background-consent"></div>
                        <p>All consent</p>
                    </div>
                    <p class="coop-table-w30 value-consent"><?php echo $data['action']['All_Consents'] //phpcs:ignore WordPress.Security ?>%</p>
                </div>
                <div class="coop-row coop-card__group-chart-info-table--border coop-card__group-chart-info-table-row">
                    <div class="coop-table-w70 coop-row-item">
                        <div class="coop-background-customize"></div>
                        <p>Customize</p>
                    </div>
                    <p class="coop-table-w30"><?php echo $data['action']['Customize'] //phpcs:ignore WordPress.Security ?>%</p>
                </div>
                <div class="coop-row coop-card__group-chart-info-table--border coop-card__group-chart-info-table-row">
                    <div class="coop-table-w70 coop-row-item">
                        <div class="coop-background-refuse"></div>
                        <p>All refuse</p>
                    </div>
                    <p class="coop-table-w30"><?php echo $data['action']['All_Refuse'] //phpcs:ignore WordPress.Security ?>%</p>
                </div>
            </div>

            <div class="coop-card__group-chart-info-render">
                <canvas id="myChart"></canvas>
            </div>

        </div>
    </div>
    <!-- end info action banner and chart -->
</div>