<?php
$nds_setDefault_languages = wp_create_nonce('nds_setDefault_languages');
$nds_delete_languages = wp_create_nonce('nds_delete_languages');
$nonce_action = wp_create_nonce('action_languages');
?>
<div class="wrap">
<hr class="wp-header-end">
    <div class="d-flex flex-row align-items-center">
        <div class="pe-3">
            <h1 class="wp-heading-inline"><?php echo esc_html__(
            	'Languages',
            	'cookie-opt'
            ); ?></h1>
        </div>
        <div><a class="button border-2" href="?page=co_languages&action=add&nonce_action=<?php echo esc_attr(
        	$nonce_action
        ); ?>"><?php echo esc_html__('Add Language', 'cookie-opt'); ?></a></div>
    </div>
    <div class="table-scrollable custom-table">
        <table class="wp-list-table widefat fixed striped table-view-list posts">
            <thead>
                <tr>
                    <th style="width: 30%;" class="manage-column"><?php echo esc_html__(
                    	'Language List',
                    	'cookie-opt'
                    ); ?></th>
                    <th style="width: 30%;" class="manage-column"><?php echo esc_html__(
                    	'Language Code',
                    	'cookie-opt'
                    ); ?></th>
                    <th style="width: 15%;" class="manage-column"></th>
                    <th style="width: 25%;" class="manage-column"></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data['array_of_banner'] as $key => $value): ?>
                    <tr>
                        <td class="custom-cell"><?php echo esc_attr(
                        	$value
                        ); ?></td>
                        <td class="custom-cell"><?php echo esc_attr(
                        	$key
                        ); ?></td>
                        <td class="custom-cell"><?php echo $data['res_by_index']->default_language != $key
                        	? ''
                        	: '<span class="badge rounded-pill custom-badge">default</span>';
                	// phpcs:ignore WordPress.Security
                	?></td>
                        <td class="d-flex custom-cell">
                            <a style="border-color: #c9d0d6;" href="?page=co_languages&action=edit&language=<?php echo esc_attr(
                            	$key
                            ); ?>&nonce_action=<?php echo esc_attr(
	$nonce_action
); ?>" 
                            class="custom-edit button btn-light-custom align-items-center"><span class="dashicons dashicons-edit"></span><?php echo esc_html__(
                            	'Edit',
                            	'cookie-opt'
                            ); ?></a>

                            <div class="dropdown">
                                <button style="border-color: #c9d0d6;" class="button" type="button" >
                                    ...
                                </button>
                                <ul class="dropdown-content position-absolute">
                                    <li><a class="dropdown-item " href="?page=co_languages&action=delete&language=<?php echo esc_attr(
                                    	$key
                                    ); ?>&verify=<?php echo esc_attr(
	$nds_delete_languages
); ?>&nonce_action=<?php echo esc_attr(
	$nonce_action
); ?>"><?php echo esc_html__('Delete', 'cookie-opt'); ?> </a></li>
                                    <li><a class="dropdown-item " href="?page=co_languages&action=default&language=<?php echo esc_attr(
                                    	$key
                                    ); ?>&verify=<?php echo esc_attr(
	$nds_setDefault_languages
); ?>&nonce_action=<?php echo esc_attr(
	$nonce_action
); ?>"><?php echo esc_html__('Set as default', 'cookie-opt'); ?></a></li>
                                </ul>
                            </div>

                            
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <!-- <button class="button hi">hi</button> -->
    </div>

</div>