<?php

use App\Services\ViewHelper\CookieOptLanguagesView;

$indexOp = 0;
$display = '';
$nds_edit_languages = wp_create_nonce('nds_edit_languages');
$nonce_action = wp_create_nonce('action_languages');
?>
<div class="wrap">
<hr class="wp-header-end">
    <form action="<?php echo esc_url(
    	admin_url('admin-post.php?language=' . $data['id'])
    ); ?>"  method="post" enctype="multipart/form-data">
    <input type="hidden" name="action" value="handle_change_languages" />
    <input type="hidden" name="nds_edit_languages" value="<?php echo esc_attr(
    	$nds_edit_languages
    ); ?>" />
    <input type="hidden" id="regulation-default" value="<?php echo esc_attr(
    	$data['res_by_index']->regulation
    ); ?>">
    <input type="hidden" name="nonce_action" value="<?php echo esc_attr(
    	$nonce_action
    ); ?>" />
    <div class="d-flex justify-content-between align-items-center pb-3">
        <div class="pe-3">
            <a class="cookie-opt__link" onclick="history.back()"><?php echo esc_html__(
            	'Back to Language List',
            	'cookie-opt'
            ); ?></a>
        </div>
        <div class="d-flex flex-row align-items-center">
            <button type="submit" class="btn btn-success btn-pub"><?php echo esc_html__(
            	'Save',
            	'cookie-opt'
            ); ?> </button>
        </div>
    </div>

    <div class="section-content border p-4">
        <div class="row">

            <?php foreach ($data['content'] as $key => $content) { ?>
                <div class="col p-2 <?php echo esc_attr(
                    'car-' . $key
                );
            ?> 
            <?php echo esc_attr(
                    $data['res_by_index']->default_language == $key || $data['id'] == $key
                        ? 'logic-show'
                        : 'logic-hidden'
            ); 
            ?>"
            data-code-parent="<?php echo esc_attr($key); ?>" 
            data-default = <?php echo esc_attr(
            	$data['res_by_index']->default_language == $key ? 'true' : 'false'
            ); ?>
            >
                <div class="border p-3">
                    <?php 
                        echo CookieOptLanguagesView::selectContent($data, $content, $key, $indexOp); // phpcs:ignore WordPress.Security
            	    ?>
                    <?php 
                        echo CookieOptLanguagesView::renderContent($data, $content, $key); // phpcs:ignore WordPress.Security
            	    ?>
                </div>
            </div>
           <?php $indexOp++;} ?>

        </div>
    </div>
    </form>
</div>

<div id="modal" class="modal">
    <!-- <?php foreach ($data['content'] as $key => $content): ?>
        
    <div data-banner="<?php echo esc_attr($key); ?>"></div>

    <?php endforeach; ?> -->
</div>