<?php
$nds_add_languages = wp_create_nonce('nds_add_languages');
$nonce_action = wp_create_nonce('action_languages');
?>
<div class="wrap">
    <hr class="wp-header-end">
    <form action="<?php echo esc_url(
        admin_url('admin-post.php')
    ); ?>" method="post">
        <input type="hidden" name="action" value="handle_add_languages" />
        <input type="hidden" name="nds_add_languages" value="<?php echo esc_attr(
            $nds_add_languages
        ); ?>" />
        <input type="hidden" name="nonce_action" value="<?php echo esc_attr(
            $nonce_action
        ); ?>" />
        <div class="d-flex flex-row align-items-center">
            <div class="pe-3">
                <h1 class="wp-heading-inline"><?php echo esc_html__(
                    'Languages Create',
                    'cookie-opt'
                ); ?></h1>
            </div>
            <div><input class="button border-2" type="submit" name="submit" value="<?php echo esc_html__(
                'Save',
                'cookie-opt'
            ); ?>"></div>
        </div>
        <div class="form-custom">
            <div class="content-add">
                <div class="title-add">
                    <h3><?php echo esc_html__(
                        'Select prefered language(s)',
                        'cookie-opt'
                    ); ?></h3>
                </div>
                <div style="padding-left: 1%;border-bottom: 1px solid;"><?php echo esc_attr(
                    $this->messageError('language')
                ); ?></div>
                <input type="text" id="myInput" placeholder="Search for names..">

                <ul id="myUL">
                    <li id="notFound"></li>
                    <?php foreach ($data['resAll'] as $key => $value): ?>
                        <li>
                            <div class="input-checkbox">
                                <div>
                                    <input id="checkbox-<?php echo esc_attr(
                                        $key
                                    ); ?>" name="language[]" value="<?php echo esc_attr(
                                         $key
                                     ); ?>" <?php echo esc_attr(
                                          in_array($key, $data['arrayKeyTaget']) ? 'checked' : ''
                                      ); ?> type="checkbox">
                                    <label for="checkbox-<?php echo esc_attr(
                                        $key
                                    ); ?>"><?php echo esc_attr(
                                         $value
                                     ); ?></label>
                                </div>
                                <div><span class='dashicons dashicons-warning'></span><span><?php echo esc_html__(
                                    'Translations not available',
                                    'cookie-opt'
                                ); ?> </span></div>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </form>
</div>