<?php
$nds_add_cookie_list = wp_create_nonce('nds_add_cookie_list');
$nds_delete_cookie_policy = wp_create_nonce('nds_delete_cookie_policy');
?>
<div id="list-of-cookies" class="coop-tab__panel">
    <form method="GET">
        <input type="hidden" name="page" value="<?php echo $_REQUEST['page'];  //phpcs:ignore WordPress.Security ?>" />
        <input type="hidden" name="index" value="list-cookie" />
        <input type="hidden" name="nonce_action" value="<?php echo esc_attr($nonce_action); ?>" />
        <?php echo $data['cookie_list_table']->search_box(__('Search', 'cookie-opt'), 'search_id'); //phpcs:ignore WordPress.Security ?>
        <?php echo $data['cookie_list_table']->display(); //phpcs:ignore WordPress.Security ?>
    </form>
    <div>
        <div style="padding: 24px 0;">
            <?php echo esc_html__('The cookie list is composed through scanning.', 'cookie-opt'); ?>
            <?php echo esc_html__('Cookies not extracted by scanning should be added manually.', 'cookie-opt'); ?>
        </div>
        <button id="scanCookieButton" class="coop-button coop-button__primary">
            <?php echo esc_html__('Run Scan', 'cookie-opt'); ?>
        </button>
        <div class="coop-ngprogress" data-process="0" style="margin-top: 8px;"></div>
    </div>

    <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin-top: 24px;" method="POST">
        <input type="hidden" name="action" value="handle_add_cookie_list" />
        <input type="hidden" name="nds_add_cookie_list" value="<?php echo esc_attr($nds_add_cookie_list); ?>" />
        <input type="hidden" name="nonce_action" value="<?php echo esc_attr($nonce_action); ?>" />
        <div class="coop-card">
            <div class="coop-card__header"><?php echo esc_html__('New Registration', 'cookie-opt'); ?></div>
            <div class="coop-card__body coop-form coop-form__list-cookie">
                <div class="coop-form__group--input">
                    <div class="coop-form__group">
                        <label class="coop-w--full" for="name"><?php echo esc_html__('Name', 'cookie-opt'); ?></label>
                        <input id="name" name="name" type="text" class="coop-form__control">
                        <?php echo esc_attr($this->messageError('name')); ?>
                    </div>

                    <div class="coop-form__group">
                        <label class="coop-w--full" for="category_id"><?php echo esc_html__('Category', 'cookie-opt'); ?></label>
                        <select id="category_id" name="category_id" class="coop-form__control coop-w--full">
                            <option selected value=""><?php echo esc_html__('Please select', 'cookie-opt'); ?></option>
                            <?php foreach ($data['data_category'] as $key => $value) { ?>
                                <option value="<?php echo esc_attr($value['id']); ?>">
                                    <?php echo esc_attr($value['name'][$data['default_language']]); ?></option>
                            <?php } ?>
                        </select>
                        <?php echo esc_attr($this->messageError('category_id')); ?>
                    </div>
                </div>

                <div class="coop-form__group">
                    <label class="coop-w--full" for="publisher"><?php echo esc_html__('Publisher', 'cookie-opt'); ?></label>
                    <input id="publisher" name="publisher" type="text" class="coop-form__control">
                    <?php echo esc_attr($this->messageError('publisher')); ?>
                </div>

                <div class="coop-form__group">
                    <label class="coop-w--full" for="description"><?php echo esc_html__('Description', 'cookie-opt'); ?></label>
                    <textarea id="description" class="coop-form__control" name="description" rows="8"></textarea>
                    <?php echo esc_attr($this->messageError('description')); ?>
                </div>
            </div>
            <div class="coop-card__footer">
                <button type="submit" class="coop-button coop-button__primary">
                    <?php echo esc_html__('Save', 'cookie-opt'); ?>
                </button>
            </div>
        </div>
    </form>
</div>