<div id="cookie-policy" class="coop-cookie__policy coop-tab__panel">
    <form target="_blank" action="<?php COOKIE_OPT_URL;
    echo esc_attr($nonce_action); ?>" />
    <p><?php echo esc_html__('The Cookie Policy page is automatically generated during startup settings.', 'cookie-opt'); ?></p>
    <div class="coop-form">
        <div class="coop-form__group">
            <select class="coop-form__control" name="coop__page-edit">
                <?php foreach ($data['all_pages'] as $page): ?>
                    <option data-edit-link="<?php echo esc_url($page['edit_link']) ?>" data-preview-link="<?php echo esc_url($page['preview_link']) ?>" selected value="<?php echo esc_attr($page['ID']); ?>">
                        <?php echo esc_attr($page['post_title']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <span class="coop-form__helptext"><?php echo esc_html__('Please select the page to review or edit.', 'cookie-opt'); ?></span>
        </div>
    </div>

    <div class="coop-cookie__policy-action">
        <a id="coop__action--confirm" target="_blank" class="coop-button coop-button__secondary">
            <?php echo esc_html__('Confirmation', 'cookie-opt'); ?>
        </a>
        <a id="coop__action--edit" target="_blank" class="coop-button coop-button__secondary">
            <?php echo esc_html__('Edit', 'cookie-opt'); ?>
        </a>
    </div>
    </form>
</div>