<?php
$nds_add_category = wp_create_nonce('nds_add_category');
?>
<div id="cookie-category" class="coop-tab__panel">
    <div class="coop-category__list">
        <?php foreach ($data['data_category'] as $key => $value) { ?>
            <div class="coop-category__item">
                <div class="coop-category__item--name"><?php echo esc_attr($value['name'][$data['default_language']]); ?>
                </div>
                <div class="coop-category__item--description">
                    <div><?php echo esc_attr($value['description'][$data['default_language']]); ?></div>
                    <button class="coop-button coop-button__secondary button-for-edit" style="margin-top: 8px;"
                        data-car-edit="<?php echo esc_attr($value['code'] . '-' . $data['default_language'] . '-' . $value['id']); ?>">
                        <?php echo esc_html__('Edit', 'cookie-opt'); ?>
                    </button>
                </div>
            </div>
        <?php } ?>
    </div>

    <form id="form-category" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin-top: 48px;"
        method="POST">
        <input type="hidden" name="action" value="handle_add_category" />
        <input type="hidden" name="nds_add_category" value="<?php echo esc_attr($nds_add_category); ?>" />
        <input type="hidden" name="nonce_action" value="<?php echo esc_attr($nonce_action); ?>" />
        <div class="coop-card">
            <div class="coop-card__header"><?php echo esc_html__('Register', 'cookie-opt'); ?></div>
            <?php foreach ($data['data_category'] as $key => $value) { ?>
                <div class="coop-card__body car-edit <?php echo esc_attr($key == 0 ? 'coop-category--show' : 'coop-category--hidden'); ?>"
                    data-car-for-edit="<?php echo esc_attr($value['code'] . '-' . $data['default_language'] . '-' . $value['id']); ?>">
                    <div class="coop-form__group">
                        <label class="coop-w--full" for="name[<?php echo esc_attr($value['id']); ?>]">
                            <?php echo esc_html__('Name', 'cookie-opt'); ?>
                        </label>
                        <input id="name[<?php echo esc_attr($value['id']); ?>]" type="text" class="coop-form__control"
                            required name="name[<?php echo esc_attr($value['id']); ?>]"
                            value="<?php echo esc_attr($value['name'][$data['default_language']]); ?>">
                        <div><?php echo esc_attr($this->messageError('name')); ?></div>
                    </div>
                    <div class="coop-form__group">
                        <label class="coop-w--full" for="description[<?php echo esc_attr($value['id']); ?>]">
                            <?php echo esc_html__('Description', 'cookie-opt'); ?>
                        </label>
                        <textarea id="description[<?php echo esc_attr($value['id']); ?>]" cols="25" rows="8"
                            class="coop-form__control" required name="description[<?php echo esc_attr($value['id']); ?>]"><?php echo esc_attr($value['description'][$data['default_language']]); ?>
                            </textarea>
                        <div><?php echo esc_attr($this->messageError('description')); ?></div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <button type="submit" class="coop-button coop-button__primary" style="margin-top: 24px;">
            <?php echo esc_html__('Save', 'cookie-opt'); ?>
        </button>
    </form>
</div>