<?php

if (!defined('ABSPATH')) exit; // Exit if accessed directly

$nds_add_cookie_list = wp_create_nonce('nds_add_cookie_list');
$nds_delete_cookie_policy = wp_create_nonce('nds_delete_cookie_policy');

?>
<div id="List-of-cookies" class="tabcontent">
    <div class="car-list-cookies">
        <div class="car-content">
            <div class="title-list-of-cookies">
                <h2><?php echo esc_html__('List of cookies used', 'cookie-optimizer') ?></h2>
                <p class="title-text"><?php echo esc_html__('The list is composed by cookie scans.', 'cookie-optimizer') ?>
                <?php echo esc_html__('Please manually add any cookies not extracted by the cookie scan.', 'cookie-optimizer') ?>
                <?php echo esc_html__('You can edit the "Description" and "Category".', 'cookie-optimizer') ?>
                </p>
            </div>
            <div class="title-list-of-cookies">
                <div class="title-button">
                    <button id="scanCookieButton" class="button"><?php echo esc_html__('Scan', 'cookie-optimizer') ?></button>
                    <!-- <button class="button button-open-add-policy" data-open-car='car-add'>add</button> -->
                </div>
                <div></div>
            </div>
        </div>
        <div class="car-content">
            <table class="wp-list-table widefat fixed striped table-view-list posts">
                <thead>
                    <tr>
                        <td style="width: 3%;" class="manage-column column-cb check-column"><label class="label-covers-full-cell" for="cb-select-all-1"><span class="screen-reader-text">Select All</span></label><input id="cb-select-all-1" type="checkbox"></td>
                        <th style="width: 20%;" class="manage-column" abbr="Title"><span><?php echo esc_html__('Name', 'cookie-optimizer') ?></span></th>
                        <th style="width: 17%; text-align: left;" class="manage-column"><?php echo esc_html__('Category', 'cookie-optimizer') ?></th>
                        <th style="width: 17%; text-align: left;" class="manage-column"><?php echo esc_html__('Publisher', 'cookie-optimizer') ?></th>
                        <th style="width: 60%; text-align: left;" class="manage-column"><?php echo esc_html__('Description', 'cookie-optimizer') ?></th>
                    </tr>
                </thead>

                <tbody>
                    <?php foreach ($data['dataPolicy'] as $key => $value) { ?>
                        <tr class="iedit author-self level-0 post-1 type-post status-publish format-standard hentry category-uncategorized">
                            <th scope="row" class="check-column">
                                <input type="checkbox" name="post[]" value="0">
                            </th>
                            <td class="title column-title has-row-actions column-primary page-title" data-colname="Title">
                                <strong><a class="row-title" href="#"><?php echo esc_attr($value['name'])  ?></a></strong>
                                <div class="row-actions">
                                    <span class="edit"><a class="edit-policy" href="<?php echo esc_url(admin_url('admin.php?page=cookie_policy&action=edit&id=' . esc_attr($value['id']) .'&nonce_action='. esc_attr($nonce_action))) ?>" aria-label="edit”"><?php echo esc_html__('Edit', 'cookie-optimizer') ?></a> | </span>
                                    <span class="trash"><a href="?page=cookie_policy&index=list-cookie&action=delete&id=<?php echo esc_attr($value['id']) ?>&verify=<?php echo esc_attr($nds_delete_cookie_policy) ?>&nonce_action=<?php echo esc_attr($nonce_action) ?>" class="submitdelete" aria-label="Trash"><?php echo esc_html__('Trash', 'cookie-optimizer') ?></a> </span>
                                </div>
                            </td>
                            <td style="text-align: left;"><?php echo esc_attr($value['category_name'][$data['default_language']]) ?></td>
                            <td style="text-align: left;"><?php echo esc_attr($value['publisher']) ?></td>
                            <td style="text-align: left;"><?php echo esc_attr($value['description']) ?></td>
                        </tr>
                    <?php  } ?>
                </tbody>
            </table>
        </div>
        <div class="car-content">
            <div class="form-cookie-list"></div>
            <div class="car-policy-form car-policy-show-title" id="car-add">
                <h2><?php echo esc_html__('Register', 'cookie-optimizer') ?></h2>
                <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
                    <input type="hidden" name="action" value="hanlde_add_cookie_list" />
                    <input type="hidden" name="nds_add_cookie_list" value="<?php echo esc_attr($nds_add_cookie_list) ?>" />
                    <input type="hidden" name="nonce_action" value="<?php echo esc_attr($nonce_action) ?>" />
                    <div class="policy-content-category">
                        <table style="width: 90%;" class="table--policy-content-category table-custom-list-cookies">
                            <thead>
                                <tr>
                                    <th style="width: 30%;"><?php echo esc_html__('Name', 'cookie-optimizer') ?></th>
                                    <th style="width: 30%;"><?php echo esc_html__('Category', 'cookie-optimizer') ?></th>
                                    <th style="width: 40%;"><?php echo esc_html__('Description', 'cookie-optimizer') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th>
                                        <input name="name" type="text" required>
                                        <?php echo esc_attr($this->messageError('name')) ?>
                                    </th>
                                    <td>
                                        <select required name="category_id" id="">
                                            <option selected disabled hidden value="">-<?php echo esc_html__('select', 'cookie-optimizer') ?>-</option>
                                            <?php foreach ($data['dataCategory'] as $key => $value) {
                                            ?>
                                                <option value="<?php echo esc_attr($value['id']) ?>"><?php echo esc_attr($value['name'][$data['default_language']]) ?></option>
                                            <?php
                                            } ?>
                                        </select>
                                        <?php echo esc_attr($this->messageError('category_id')) ?>
                                    </td>
                                    <td>
                                        <textarea class="textarea-policy" name="description" rows="4" required></textarea>
                                        <?php echo esc_attr($this->messageError('description')) ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><button type="submit" class="button"><?php echo esc_html__('Save', 'cookie-optimizer') ?></button></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>