<?php
$nonce_action = wp_create_nonce('action_policy');
$nonce_ajax_scan = wp_create_nonce('ajax_scan');
?>
<section class="coop-section">
	<h1 class="coop-heading"><?php echo esc_html__('Cookie List Settings', 'cookie-opt'); ?></h1>
	<div class="coop-tab coop-bg-white">
		<input type="hidden" name="ajax_scan" value="<?php echo esc_attr($nonce_ajax_scan); ?>">
		<button class="coop-tab__link <?php echo esc_attr(($data['page_index'] == 'category') ? 'active' : ''); ?>"
			data-tab="cookie-category">
			<?php echo esc_html__('Cookie Type', 'cookie-opt'); ?>
		</button>
		<button class="coop-tab__link <?php echo esc_attr(($data['page_index'] == 'list-cookie') ? 'active' : ''); ?>"
			data-tab="list-of-cookies">
			<?php echo esc_html__('List of Active Cookies', 'cookie-opt'); ?>
		</button>
		<button class="coop-tab__link <?php echo esc_attr(($data['page_index'] == 'policy') ? 'active' : ''); ?>"
			data-tab="cookie-policy">
			<?php echo esc_html__('Cookie Policy', 'cookie-opt'); ?>
		</button>
	</div>
	<div class="coop-tab__content">
		<?php
		require_once 'partials/cookie-category.php';
		require_once 'partials/list-of-cookies.php';
		require_once 'partials/cookie-policy.php';
		?>
	</div>
</section>