<?php if (!defined('ABSPATH')) exit; // Exit if accessed directly ?>

<div id="Cookie-Policy" class="tabcontent">
    <div class="car-list-cookies">
        <form target="_blank" action="<?php COOKIE_OPT_URL ?>" method="get">
            <input type="hidden" name="action" value="policy">
            <input type="hidden" name="_method" value="GET">
            <input type="hidden" name="page" value="cookie_policy">
            <input type="hidden" name="nonce_action" value="<?php echo esc_attr($nonce_action) ?>" />
            <div class="car-content">
                <div class="title-list-of-cookies">
                    <h3><?php echo esc_html__('Cookie Policy', 'cookie-optimizer') ?></h3>
                    <p class="title-text">
                        <?php echo esc_html__('The Cookie Policy page is automatically generated during startup. Please check the page below.', 'cookie-optimizer') ?>
                    </p>
                </div>
                <div class="title-list-of-cookies">
                    <div class="title-button">
                        <!-- <button class="button"><?php echo esc_html__('Generation', 'cookie-optimizer') ?></button> -->
                    </div>
                    <div></div>
                </div>

            </div>
            <div class="car-content">
                <div class="d-flex flex-row car-custom-policy">
                    <select id="page-policy">
                        <?php foreach ($data['allPages'] as $page) : ?>
                            <option id="page-policy-ID" selected value="<?php echo esc_attr($page->ID) ?>"><?php echo esc_attr( $page->post_title)//echo esc_html__('Cookie Policy', 'cookie-optimizer') ?></option>
                        <?php endforeach; ?>
                    </select>
                    <a id="link-preview" href="<?php echo esc_attr($data['pageReview']) ?>" target="_blank" class="button"><?php echo esc_html__('Check out our cookie policy page', 'cookie-optimizer') ?></a>
                    <a id="link-edit" href="<?php echo esc_attr($data['postEdit']) ?>" target="_blank" class="button"><?php echo esc_html__('Edit the Cookie Policy page', 'cookie-optimizer') ?></a>
                    <!-- <input type="hidden" id="policy" name="page-policy" value="1">
                    <label for="policy"><?php echo esc_html__('Cookie Policy', 'cookie-optimizer') ?></label> -->
                </div>
            </div>
        </form>
    </div>
</div>