<?php
$nds_edit_cookie_list = wp_create_nonce('nds_edit_cookie_list');
$nonce_action = wp_create_nonce('action_policy');
?>

<section class="coop-section">
    <h1 class="coop-heading"><?php echo esc_html__('Cookie List Settings > Edit', 'cookie-opt'); ?></h1>
    <form action="<?php echo esc_url(admin_url('admin-post.php')) . '?id=' . esc_attr($data['list_by_id']->id); ?>"
        method="POST">
        <input type="hidden" name="action" value="handle_edit_cookie_list" />
        <input type="hidden" name="nds_edit_cookie_list" value="<?php echo esc_attr($nds_edit_cookie_list); ?>" />
        <input type="hidden" name="nonce_action" value="<?php echo esc_attr($nonce_action); ?>" />

        <div class="coop-form__category-edit">
            <h4><?php echo esc_html__('Edit Cookie', 'cookie-opt'); ?></h4>
            <div class="coop-form__group">
                <label>
                    <?php echo esc_html__('Name', 'cookie-opt'); ?>
                </label>
                <div><?php echo esc_attr($data['list_by_id']->name); ?></div>
                <input hidden name="name" type="text" value="<?php echo esc_attr($data['list_by_id']->name); ?>" readonly
                    required>
                <?php echo esc_attr($this->messageError('name')); ?>
            </div>

            <div class="coop-form__group">
                <label for="category_id"><?php echo esc_html__('Category', 'cookie-opt'); ?></label>
                <select name="category_id" id="category_id" class="coop-form__control" required>
                    <?php foreach ($data['data_category'] as $key => $value) { ?>
                        <option <?php echo esc_attr($value['id'] == $data['list_by_id']->categoryID) ? 'selected' : '' ?>
                            value="<?php echo esc_attr($value['id']); ?>"><?php echo esc_attr($value['name'][$data['default_language']]); ?>
                        </option>
                    <?php } ?>
                </select>
                <?php echo esc_attr($this->messageError('category_id')); ?>
            </div>

            <div class="coop-form__group">
                <label for="description"><?php echo esc_html__('Description', 'cookie-opt'); ?></label>
                <textarea id="description" class="coop-form__control" name="description" rows="7"
                    required><?php echo esc_attr($data['list_by_id']->description); ?></textarea>
                <?php echo esc_attr($this->messageError('description')); ?>
            </div>
        </div>

        <button type="submit" class="coop-button coop-button__primary">
            <?php echo esc_html__('Save', 'cookie-opt'); ?>
        </button>
    </form>
</section>