<?php

if (!defined('ABSPATH')) exit; // Exit if accessed directly

$nds_add_category = wp_create_nonce('nds_add_category');
?>
<div id="Cookie-Category" class="tabcontent">
    <div class="car-lang-category">
        <div class="cookie-category-title">
            <h2><?php echo esc_html__('Cookie Category', 'cookie-optimizer') ?></h2>
        </div>
        <!--  -->
        <div class="policy-content-category">
            <table class="table--policy-content-category">
                <thead>
                    <tr>
                        <th style="width: 30%;"><?php echo esc_html__('Name', 'cookie-optimizer') ?></th>
                        <th style="width: 70%;"><?php echo esc_html__('Description', 'cookie-optimizer') ?></th>
                        <th style="width: 10%;"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data['dataCategory']  as $key => $value) { ?>
                        <tr>
                            <th><?php echo esc_attr($value["name"][$data['default_language']]) ?></th>
                            <td><?php echo esc_attr($value["description"][$data['default_language']]) ?></td>
                            <td><button data-car-edit="<?php echo esc_attr($value['code'] . '-' . $data['default_language'] . '-' . $value['id']) ?>" class="button button-for-edit"><?php echo esc_html__('Edit', 'cookie-optimizer') ?></button></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
    <hr>
    <h2><?php echo esc_html__('Edit', 'cookie-optimizer') ?></h2>
    <div id="form-category"></div>
    <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
        <div class="policy-content-category">
            <input type="hidden" name="action" value="hanlde_add_category" />
            <input type="hidden" name="nds_add_category" value="<?php echo esc_attr($nds_add_category) ?>" />
            <input type="hidden" name="nonce_action" value="<?php echo esc_attr($nonce_action) ?>" />
            <table class="table--policy-content-category">
                <thead>
                    <tr>
                        <th style="width: 30%;"><?php echo esc_html__('Name', 'cookie-optimizer') ?></th>
                        <th style="width: 70%;"><?php echo esc_html__('Description', 'cookie-optimizer') ?></th>
                        <th style="width: 10%;"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data['dataCategory']  as $key => $value) { ?>

                        <tr class="car-edit <?php echo esc_attr(($key == 0) ? 'car-policy-show' : 'car-policy-hiden') ?>" data-car-for-edit="<?php echo esc_attr($value['code'] . '-' . $data['default_language'] . '-' . $value['id']) ?>">
                            <th>
                                <textarea required class="edit-category" name="name[<?php echo esc_attr($value['id']) ?>]" cols="25" rows="2"><?php echo esc_attr($value['name'][$data['default_language']]) ?></textarea>
                                <div><?php echo esc_attr($this->messageError('name')) ?></div>
                            </th>
                            <td>
                                <textarea required class="edit-category" name="description[<?php echo esc_attr($value['id']) ?>]" rows="6"><?php echo esc_attr($value['description'][$data['default_language']]) ?></textarea>
                                <div><?php echo esc_attr($this->messageError('description')) ?></div>
                            </td>
                            <td></td>
                        </tr>

                    <?php }
                    ?>
                    <tr>
                        <td><button type="submit" class="button"><?php echo esc_html__('Save', 'cookie-optimizer') ?></button></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </form>
    <!--  -->
</div>