<!-- Title -->
<div class="coop-group__col-2">
    <div>
        <h2>
            <?php echo esc_html__('Title', 'cookie-opt'); ?>
        </h2>
    </div>
    <div>
        <div class="coop-w--full">
            <input type="text" class="coop-form__control coop-change-value" data-value-change="banner-title"
                name="coop-setting__title" value="<?php echo esc_html($data['setting']['title']) ?>">
        </div>
        <div>
            <?php $this->messageError('title') ?>
        </div>
    </div>
</div>

<!-- Description -->
<div class="coop-group__col-2">
    <div>
        <h2>
            <?php echo esc_html__('Message', 'cookie-opt'); ?>
        </h2>
    </div>

    <div class="coop-form__group coop-item__left">
        <div class="coop-w--full">
            <textarea type="text" class="coop-form__control coop-change-value" data-value-change="banner-description"
                name="coop-setting__description"><?php echo esc_html($data['setting']['description']) ?></textarea>
        </div>
        <span>
            <?php echo esc_html__('Please enter the cookie notification message.', 'cookie-opt'); ?>
        </span>
        <div>
            <?php $this->messageError('description') ?>
        </div>
    </div>
</div>

<!-- Group Button setting -->
<div class="coop-group__col-2">
    <div>
        <h2>
            <?php echo esc_html__('Button Settings', 'cookie-opt'); ?>
        </h2>
    </div>
    <div>
        <!-- Accept button -->
        <div class="coop-group__col-2">
            <div>
                <span>
                    <?php echo esc_html__('Consent', 'cookie-opt'); ?>
                </span>
            </div>
            <div class="coop-form__group coop-item__left">
                <input type="text" class="coop-form__control coop-form__control--md coop-change-value"
                    data-value-change="banner-accept_button" name="coop-setting__accept-btn"
                    value="<?php echo esc_html($data['setting']['buttons']['accept']['content']) ?>">
                <span>
                    <?php echo esc_html__('The text of the option to accept the notice and make it disappear.', 'cookie-opt'); ?>
                </span>
                <div>
                    <?php $this->messageError('accept_btn') ?>
                </div>
            </div>
        </div>

        <!-- Reject button -->
        <div class="coop-group__col-2 coop-display">
            <div>
                <span>
                    <?php echo esc_html__('Rejection', 'cookie-opt'); ?>
                </span>
            </div>
            <div>
                <!-- Reject status -->
                <div class="coop-form__group coop-form__group--inline">
                    <input type="checkbox" class="coop-form__checkbox coop-status" id="coop-setting__reject-btn__status"
                        name="coop-setting__reject-status" data-target="coop-group__reject"
                        data-value-change-status="banner-reject_button" <?php echo esc_html($data['setting']['buttons']['reject']['status']) ?>>
                    <label for="coop-setting__reject-btn__status" class="coop-item__pointer">
                        <?php echo esc_html__('Please enter the text to display on the button.', 'cookie-opt') ?>
                    </label>
                </div>

                <br>
                <!-- Reject content button -->
                <div data-group="coop-group__reject" class="coop-form__group coop-item__left coop-container">
                    <input type="text" class="coop-form__control coop-form__control--md coop-change-value"
                        data-value-change="banner-reject_button" name="coop-setting__reject-btn"
                        value="<?php echo esc_html($data['setting']['buttons']['reject']['content']) ?>">
                    <span>
                        <?php echo esc_html__('Text for the Decline Consent Button', 'cookie-opt'); ?>
                    </span>
                    <div>
                        <?php $this->messageError('reject_btn') ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cookie Policy button -->
        <div data-display="ja" class="coop-group__col-2 coop-display">
            <div>
                <span>
                    <?php echo esc_html__('Cookie Button', 'cookie-opt'); ?>
                </span>
            </div>
            <div class="coop-form__group coop-item__left">
                <input type="text" class="coop-form__control coop-form__control--md coop-change-value"
                    data-value-change="banner-cookie_policy_button" name="coop-setting__cookie-policy-btn"
                    value="<?php echo esc_html($data['setting']['buttons']['cookie_policy']['content']) ?>">
                <span>
                    <?php echo esc_html__('Cookie Policy Button text', 'cookie-opt'); ?>
                </span>
                <div>
                    <?php $this->messageError('cookie_policy_btn') ?>
                </div>
            </div>
        </div>


        <!-- Privacy Policy button -->
        <div class="coop-group__col-2">
            <div>
                <span>
                    <?php echo esc_html__('Privacy Button', 'cookie-opt'); ?>
                </span>
            </div>
            <div>
                <!-- Privacy Policy status -->
                <div>
                    <div class="coop-form__group coop-form__group--inline">
                        <input type="checkbox" class="coop-form__checkbox coop-status"
                            id="coop-setting__pri-policy--status" name="coop-setting__pri-policy-status"
                            data-target="coop-group__pri-policy" data-value-change-status="banner-privacy_policy_button"
                            <?php echo esc_html($data['setting']['buttons']['pri_policy']['status']) ?>>
                        <label for="coop-setting__pri-policy--status" class="coop-item__pointer">
                            <?php echo esc_html__('Enable', 'cookie-opt') ?>
                        </label>
                    </div>
                </div>

                <br>

                <div data-group="coop-group__pri-policy" class="coop-form__group coop-item__left coop-container">
                    <!-- Button content -->
                    <div class="coop-form__group coop-item__left">
                        <input type="text" class="coop-form__control coop-form__control--md coop-change-value"
                            data-value-change="banner-privacy_policy_button" name="coop-setting__pri-policy-btn"
                            value="<?php echo esc_html($data['setting']['buttons']['pri_policy']['content']) ?>">
                        <span>
                            <?php echo esc_html__('Please enter the text to display on the button.', 'cookie-opt'); ?>
                        </span>
                        <div>
                            <?php $this->messageError('pri_policy_btn') ?>
                        </div>
                    </div>

                    <!-- Group setting privacy policy -->
                    <div class="coop-form__group coop-item__left">
                        <span>
                            <b><?php echo esc_html__('Link Settings ', 'cookie-opt'); ?></b>
                        </span>
                        <div class="coop-form__group coop-form__group--inline coop-w-fit">
                            <!-- <select name="coop-setting__page-link" class="coop-form__control coop-w-fit">
                                        <option selected>
                                            <?php echo esc_html__('Page Link', 'cookie-opt'); ?>
                                        </option>
                                    </select> -->
                            <select name="coop-setting__pri-policy-page-id" class="coop-form__control coop-w-fit">
                                <?php foreach ($data['setting']['all_page'] as $key => $item): ?>
                                    <option <?php $this->propSelected($data['setting']['buttons']['pri_policy']['link'], $item->ID) ?> value="<?php echo esc_attr($item->ID) ?>">
                                        <?php echo esc_html($item->post_title) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div>
                                <select name="coop-setting__pri-policy-target" class="coop-form__control coop-w-fit">
                                    <option <?php $this->propSelected($data['setting']['buttons']['pri_policy']['link_target'], '_blank') ?> value="_blank">
                                        <?php echo esc_html__('Open in a New Tab', 'cookie-opt'); ?>
                                    </option>
                                    <option <?php $this->propSelected($data['setting']['buttons']['pri_policy']['link_target'], '_self') ?> value="_self">
                                        <?php echo esc_html__('Display in the Same Tab', 'cookie-opt'); ?>
                                    </option>
                                </select>
                                <!-- <span>
                                            <?php echo esc_html__('Please select the page to display. ', 'cookie-opt'); ?>
                                </span> -->
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <!-- Group customize banner -->
        <div class="coop-group__col-2 coop-display">
            <div>
                <span>
                    <?php echo esc_html__('Customize', 'cookie-opt'); ?>
                </span>
            </div>
            <div class="coop-form__group coop-item__left">
                <!-- Customize banner status -->
                <div class="coop-form__group coop-form__group--inline">
                    <input type="checkbox" class="coop-form__checkbox coop-status" id="coop-setting__custom-btn__status"
                        name="coop-setting__cus-status" data-target="coop-group__customize"
                        data-value-change-status="banner-customize_button" <?php echo esc_html($data['setting']['customize']['status']) ?>>
                    <label for="coop-setting__custom-btn__status" class="coop-item__pointer">
                        <?php echo esc_html__('Enable', 'cookie-opt') ?>
                    </label>
                </div>

                <!-- Group setting customize banner -->
                <div data-group="coop-group__customize" class="coop-container">
                    <!-- Customize button -->
                    <div class="coop-form__group coop-item__left">
                        <input type="text" class="coop-form__control coop-change-value"
                            data-value-change="banner-customize_button" name="coop-setting__cus-btn"
                            value="<?php echo esc_html($data['setting']['customize']['content']) ?>">
                        <div>
                            <?php $this->messageError('customize_btn') ?>
                        </div>
                        <span>
                            <?php echo esc_html__('Please enter the text to display on the button.', 'cookie-opt'); ?>
                        </span>
                    </div>

                    <!-- Title -->
                    <div class="coop-form__group coop-item__left">
                        <input type="text" class="coop-form__control coop-change-value"
                            data-value-change="banner-cus-title" name="coop-setting__cus-title"
                            value="<?php echo esc_html($data['setting']['customize']['title']) ?>">
                        <div>
                            <?php $this->messageError('customize_title') ?>
                        </div>
                        <span>
                            <?php echo esc_html__('Please enter the text to display as the title.', 'cookie-opt'); ?>
                        </span>
                    </div>

                    <!-- Description -->
                    <div class="coop-form__group coop-item__left">
                        <input type="text" class="coop-form__control coop-change-value"
                            data-value-change="banner-cus-des" name="coop-setting__cus-des"
                            value="<?php echo esc_html($data['setting']['customize']['description']) ?>">
                        <div>
                            <?php $this->messageError('customize_des') ?>
                        </div>
                        <span>
                            <?php echo esc_html__('Please enter the content for description.', 'cookie-opt'); ?>
                        </span>
                    </div>

                    <!-- Here Link -->
                    <div class="coop-form__group coop-item__left">
                        <input type="text" class="coop-form__control coop-change-value"
                            data-value-change="banner-here-link" name="coop-setting__cus-here"
                            value="<?php echo esc_html($data['setting']['customize']['here']) ?>">
                        <div>
                            <?php $this->messageError('here') ?>
                        </div>
                        <span>
                            <?php echo esc_html__('Please enter the content for the link.', 'cookie-opt'); ?>
                        </span>
                    </div>

                    <!-- Save Button -->
                    <div class="coop-form__group coop-item__left">
                        <input type="text" class="coop-form__control coop-change-value"
                            data-value-change="banner-save_button" name="coop-setting__cus-save-btn"
                            value="<?php echo esc_html($data['setting']['customize']['button_save']) ?>">
                        <div>
                            <?php $this->messageError('customize_save_btn') ?>
                        </div>
                        <span>
                            <?php echo esc_html__('Please enter the text for the Save Changes button.', 'cookie-opt'); ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cookies Terms of User button -->
        <div data-display="us" class="coop-group__col-2 coop-display">
            <div>
                <span>
                    <?php echo esc_html__('Do Not Sell Personal Information', 'cookie-opt'); ?>
                </span>
            </div>
            <div class="coop-form__group coop-item__left">

                <!-- Term of use status -->
                <div class="coop-form__group coop-form__group--inline">
                    <input type="checkbox" class="coop-form__checkbox coop-status"
                        id="coop-setting__term-of-use-btn__status" name="coop-setting__term-of-use-status"
                        data-target="coop-group__term-of-use" data-value-change-status="banner-do_not_sell_page_button"
                        <?php echo esc_html($data['setting']['buttons']['term_of_use']['status']) ?>>
                    <label for="coop-setting__term-of-use-btn__status" class="coop-item__pointer">
                        <?php echo esc_html__('Enable', 'cookie-opt') ?>
                    </label>
                </div>

                <!-- Group setting -->
                <div data-group="coop-group__term-of-use" class="coop-container">
                    <!-- Button content -->
                    <div class="coop-form__group coop-item__left">
                        <input type="text" class="coop-form__control coop-form__control--md coop-change-value"
                            data-value-change="banner-do_not_sell_page_button" name="coop-setting__term-of-use-btn"
                            value="<?php echo esc_html($data['setting']['buttons']['term_of_use']['content']) ?>">
                        <span>
                            <?php echo esc_html__('Please enter the text to display on the button.', 'cookie-opt'); ?>
                        </span>
                        <div>
                            <?php $this->messageError('term_of_use_btn') ?>
                        </div>
                    </div>

                    <!-- Generate button -->
                    <div class="coop-form__group coop-form__group--inline">
                        <span><?php echo esc_html__('Generate a Fixed Page for Opt-Out Rights Notification', 'cookie-opt'); ?>
                        </span>
                        <button id="coop-setting__generate-term-of-use-page" type="button"
                            class="coop-button coop-button__secondary"><?php echo esc_html__('Generate', 'cookie-opt'); ?></button>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cookie retention period -->
<div class="coop-group__col-2 coop-display">
    <div>
        <h2>
            <?php echo esc_html__('Cookie Storage Duration', 'cookie-opt'); ?>
        </h2>
    </div>
    <div>
        <div class="coop-group__col-2">
            <span>
                <?php echo esc_html__('Duration to Store Cookies After User Consent', 'cookie-opt'); ?>
            </span>
            <select class="coop-form__control coop-form__control--md coop-h--fit" name="coop-setting__expired"
                id="coop-setting__expired">
                <option value="hour" <?php $this->propSelected($data['setting']['expired'], 'hour') ?>>
                    <?php echo 1 . esc_html__('An hour', 'cookie-opt'); ?>
                </option>
                <option value="day" <?php $this->propSelected($data['setting']['expired'], 'day') ?>>
                    <?php echo 1 . esc_html__('day', 'cookie-opt'); ?>
                </option>
                <option value="week" <?php $this->propSelected($data['setting']['expired'], 'week') ?>>
                    <?php echo 1 . esc_html__('week', 'cookie-opt'); ?>
                </option>
                <option value="month" <?php $this->propSelected($data['setting']['expired'], 'month') ?>>
                    <?php echo 1 . esc_html__('month', 'cookie-opt'); ?>
                </option>
                <option value="3months" <?php $this->propSelected($data['setting']['expired'], '3month') ?>>
                    <?php echo 3 . esc_html__('months', 'cookie-opt'); ?>
                </option>
                <option value="6months" <?php $this->propSelected($data['setting']['expired'], '6month') ?>>
                    <?php echo 6 . esc_html__('months', 'cookie-opt'); ?>
                </option>
                <option value="year" <?php $this->propSelected($data['setting']['expired'], 'year') ?>>
                    <?php echo 1 . esc_html__('year', 'cookie-opt'); ?>
                </option>
                <option value="infinity" <?php $this->propSelected($data['setting']['expired'], 'infinity') ?>>
                    <?php echo esc_html__('infinity', 'cookie-opt'); ?>
                </option>
            </select>
        </div>
        <div>
            <?php $this->messageError('expired') ?>
        </div>
    </div>
</div>

<!-- Geolocation Setting -->
<div class="coop-group__col-2">
    <div>
        <h2>
            <?php echo esc_html__('Agreement popup display region settings', 'cookie-opt'); ?>
        </h2>
    </div>
    <div>
        <!-- Geolocation status -->
        <div class="coop-form__group coop-form__group--inline">
            <div class="coop-item__center">
                <div class="coop-toggle__switch">
                    <input class="coop-toggle__input coop-status" id="setting__geolocation-status" type="checkbox"
                        data-page-preview="setting" name="coop-setting__geolocation-status"
                        data-target="coop-group__geolocation" <?php echo esc_html($data['setting']['geolocation']['status']) ?>>
                    <label class="coop-toggle__label" for="setting__geolocation-status"></label>
                </div>
            </div>
            <!-- <input type="checkbox" id="setting__geolocation-status" class="coop-form__checkbox coop-status" name="coop-setting__geolocation-status" data-target="coop-group__geolocation" <?php echo esc_html($data['setting']['geolocation']['status']) ?> >
                    <label for="setting__geolocation-status" class="coop-item__pointer">
                        <?php echo esc_html__('To Set', 'cookie-opt'); ?>
                    </label> -->
        </div>

        <br>
        <!-- Group setup geolocation -->
        <div data-group="coop-group__geolocation" class="coop-container">
            <!-- Option -->
            <select class="coop-form__control coop-form__control--md coop-h--fit coop-status"
                name="coop-setting__geolocation-value" id="setting__generation-value"
                data-target="coop-group__geolocation">
                <option data-target="coop-group__geolocation-auto" value="auto" <?php echo esc_attr($data['setting']['geolocation']['type']['auto']) ?>>
                    <?php echo esc_html__('Automatic', 'cookie-opt'); ?>
                </option>
                <option data-target="coop-group__geolocation-manual" value="manual" <?php echo esc_attr($data['setting']['geolocation']['type']['manual']) ?>>
                    <?php echo esc_html__('Manual', 'cookie-opt'); ?>
                </option>
            </select>

            <!-- Group Setting -->
            <div data-group="coop-group__geolocation" class="coop-container">
                <div data-group="coop-group__geolocation-auto" class="coop-container"></div>

                <!-- Setting Manual -->
                <div data-group="coop-group__geolocation-manual" class="coop-container">
                    <table class="coop-table coop-table__collapse">
                        <tbody class="coop-table__body coop-text__center">
                            <tr>
                                <td class="coop-text__left"></td>
                                <td>
                                    <?php echo esc_html__('Japan', 'cookie-opt'); ?>
                                </td>
                                <td>
                                    <?php echo esc_html__('US', 'cookie-opt'); ?>
                                </td>
                                <td>
                                    <?php echo esc_html__('EU', 'cookie-opt'); ?>
                                </td>
                                <td>
                                    <?php echo esc_html__('Add new tag', 'cookie-opt'); ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="coop-text__left">
                                    <?php echo esc_html__('Banner Display', 'cookie-opt'); ?>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__display-banner-ja" <?php echo esc_attr($data['setting']['geolocation']['setting']['banner_display']['ja']) ?>>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__display-banner-us" <?php echo esc_attr($data['setting']['geolocation']['setting']['banner_display']['us']) ?>>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__display-banner-eu" <?php echo esc_attr($data['setting']['geolocation']['setting']['banner_display']['eu']) ?>>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__display-banner-other" <?php echo esc_attr($data['setting']['geolocation']['setting']['banner_display']['other']) ?>>
                                </td>
                            </tr>
                            <tr>
                                <td class="coop-text__left">
                                    <?php echo esc_html__('Privacy Policy', 'cookie-opt'); ?>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__pri-policy-link-ja" <?php echo esc_attr($data['setting']['geolocation']['setting']['pri_policy_link']['ja']) ?>>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__pri-policy-link-us" <?php echo esc_attr($data['setting']['geolocation']['setting']['pri_policy_link']['us']) ?>>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__pri-policy-link-eu" <?php echo esc_attr($data['setting']['geolocation']['setting']['pri_policy_link']['eu']) ?>>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__pri-policy-link-other" <?php echo esc_attr($data['setting']['geolocation']['setting']['pri_policy_link']['other']) ?>>
                                </td>
                            </tr>
                            <tr data-display="us" class="coop-display">
                                <td class="coop-text__left">
                                    <?php echo esc_html__('Stop Selling Personal Information', 'cookie-opt'); ?>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox" disabled>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox"
                                        name="coop-setting__term-of-use-us" <?php echo esc_attr($data['setting']['geolocation']['setting']['term_of_use']['us']) ?>>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox" disabled>
                                </td>
                                <td>
                                    <input type="checkbox" class="coop__form__checkbox" disabled>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- On Scroll -->
<div class="coop-group__col-2">
    <div>
        <h2>
            <?php echo esc_html__('Display on Scroll', 'cookie-opt'); ?>
        </h2>
    </div>
    <div class="coop-form__group coop-item__left">
        <!-- Onscroll status -->
        <div class="coop-form_-group coop-form__group--inline">
            <div class="coop-toggle__switch">
                <input class="coop-toggle__input coop-status" id="setting__onscroll" type="checkbox"
                    data-page-preview="setting" name="coop-setting__onscroll-status" data-target="coop-group__onscroll"
                    <?php echo esc_html($data['setting']['on_scroll']['status']) ?>>
                <label class="coop-toggle__label" for="setting__onscroll"></label>
            </div>
            <!-- <input type="checkbox" id="setting__onscroll" class="coop-form__checkbox coop-status" name="coop-setting__onscroll-status" data-target="coop-group__onscroll" <?php echo esc_html($data['setting']['on_scroll']['status']) ?>>
                    <label for="setting__onscroll" class="coop-item__pointer">
                    <?php echo esc_html__('Enable', 'cookie-opt'); ?>
                    </label> -->
        </div>

        <!-- Group setting onscroll -->
        <div data-group="coop-group__onscroll" class="coop-form__group coop-item__left coop-container">
            <span>
                <?php echo esc_html__('Hide the consent banner when the user scrolls.', 'cookie-opt'); ?>
            </span>
            <br>

            <!-- Group Scroll Value -->
            <div class="coop-form__group coop-item__left">
                <div class="coop-form__group coop-form__group--inline">
                    <input type="text" class="coop-form__control coop-w--fit small-text"
                        name="coop-setting__onscroll-value"
                        value="<?php echo esc_html($data['setting']['on_scroll']['value']) ?>">
                    <span>px</span>
                </div>
                <span>
                    <?php echo esc_html__('Number of pixels user has to scroll to accept the notice and make it disappear.', 'cookie-opt'); ?>
                </span>
                <div>
                    <?php $this->messageError('onscroll_value') ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- On Click -->
<div class="coop-group__col-2">
    <div>
        <h2>
            <?php echo esc_html__('Display on Screen Click', 'cookie-opt'); ?>
        </h2>
    </div>
    <div class="coop-form__group coop-item__left">
        <div class="coop-form__group coop-form__group--inline">
            <div class="coop-toggle__switch">
                <input class="coop-toggle__input coop-status" id="setting__onclick" type="checkbox"
                    data-page-preview="setting" name="coop-setting__on-click" data-target="coop-group__onclick" <?php echo esc_html($data['setting']['on_click']) ?>>
                <label class="coop-toggle__label" for="setting__onclick"></label>
            </div>
            <!-- <input type="checkbox" id="setting__onclick" class="coop-form__checkbox coop-status" data-target="coop-group__onclick" name="coop-setting__on-click" <?php echo esc_html($data['setting']['on_click']) ?>>
                    <label for="setting__onclick" class="coop-item__pointer">
                    <?php echo esc_html__('Enable', 'cookie-opt'); ?>
                    </label> -->
        </div>
        <div data-group="coop-group__onclick" class="coop-container">
            <span>
                <?php echo esc_html__('Enable the function that assumes cookie consent when clicking anywhere on a page where the consent banner is displayed.', 'cookie-opt'); ?>
            </span>
        </div>
    </div>
</div>

<!-- Conditional Display -->
<div class="coop-group__col-2">
    <div>
        <h2>
            <?php echo esc_html__('Conditional Banner Display', 'cookie-opt'); ?>
        </h2>
    </div>
    <div>
        <!-- Conditional Status -->
        <div class="coop-form__group coop-form__group--inline">
            <div class="coop-toggle__switch">
                <input class="coop-toggle__input coop-status" id="setting__conditional-status" type="checkbox"
                    data-page-preview="setting" name="coop-setting__conditional-status"
                    data-target="coop-group__conditional" <?php echo esc_html($data['setting']['conditional']['status']) ?>>
                <label class="coop-toggle__label" for="setting__conditional-status"></label>
            </div>
            <!-- <input type="checkbox" id="setting__conditional-status" class="coop-form__checkbox coop-status" name="coop-setting__conditional-status" data-target="coop-group__conditional" <?php echo esc_html($data['setting']['conditional']['status']) ?>>
                    <label for="setting__conditional-status" class="coop-item__pointer">
                    <?php echo esc_html__('Enable', 'cookie-opt'); ?>
                    </label> -->
        </div>

        <!-- Group setting conditional -->
        <div data-group="coop-group__conditional" class="coop-container">
            <div class="coop-form__group coop-item__left">
                <span>
                    <?php echo esc_html__('Enable conditional banner display for the banner.', 'cookie-opt'); ?>
                </span>
            </div>
            <br>
            <!-- Rule option -->
            <select class="coop-form__control coop-h--fit coop-w--fit coop-status" name="coop-setting__conditional-rule"
                id="setting__conditional-rule" data-target="coop-group__conditional">
                <option data-target="coop-group__conditionals-show" value="show" selected>
                    <?php echo esc_html__('Display the Banner', 'cookie-opt'); ?>
                </option>
                <option data-target="coop-group__conditionals-hide" value="hide">
                    <?php echo esc_html__('Hide the Banner', 'cookie-opt'); ?>
                </option>
            </select>

            <div class="coop-form__group coop-item__left">
                <span>
                    <?php echo esc_html__('Select whether to display the banner when the following conditions are met.', 'cookie-opt'); ?>
                </span>
            </div>
            <br>
            <!-- Rule list -->
            <div data-group="coop-group__conditional" class="coop-container">
                <!-- Rules list show -->
                <div data-group="coop-group__conditionals-show" class="coop-container">
                    <?php if (count($data['setting']['conditional']['rules']['show']) !== 0):?>
                        <?php foreach ($data['setting']['conditional']['rules']['show'] as $key => $rule): ?>
                            <div data-id="<?php echo esc_attr($key) ?>" class="coop-rule">
                                <div data-id="<?php echo esc_attr($key) ?>" class="coop-form__group coop-form__group--inline">

                                    <!-- Type conditional -->
                                    <select class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__type"
                                        name="coop-setting__conditional[rule][show][<?php echo esc_attr($key) ?>][type]">
                                        <option <?php $this->propSelected($rule['type'], 'page_type') ?> value="page_type">
                                            <?php echo esc_html__('Page Type', 'cookie-opt') ?>
                                        </option>
                                        <option <?php $this->propSelected($rule['type'], 'page') ?> value="page">
                                            <?php echo esc_html__('Page', 'cookie-opt') ?></option>
                                        <option <?php $this->propSelected($rule['type'], 'post_type') ?> value="post_type">
                                            <?php echo esc_html__('Post Type', 'cookie-opt') ?></option>
                                        <option <?php $this->propSelected($rule['type'], 'user_type') ?> value="user_type">
                                            <?php echo esc_html__('User Type', 'cookie-opt') ?></option>
                                    </select>

                                    <!-- Operator -->
                                    <select class="coop-form__control coop-form__control--md coop-h--fit"
                                        name="coop-setting__conditional[rule][show][<?php echo esc_attr($key) ?>][operator]">
                                        <option <?php $this->propSelected($rule['operator'], 'equal') ?> value="equal">
                                            <?php echo esc_html__('Equal to', 'cookie-opt'); ?>
                                        </option>
                                        <option <?php $this->propSelected($rule['operator'], 'not-equal') ?> value="not-equal">
                                            <?php echo esc_html__('Not equal to', 'cookie-opt'); ?>
                                        </option>
                                    </select>

                                    <!-- Group Value Type Conditional - Show list -->
                                    <?php if ($rule['type'] == 'page_type'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][show][<?php echo esc_attr($key) ?>][value]">
                                            <option <?php $this->propSelected($rule['value'], 'front') ?> value="front">
                                                <?php echo esc_html__('Front Page', 'cookie-opt'); ?>
                                            </option>
                                            <option <?php $this->propSelected($rule['value'], 'home') ?> value="home">
                                                <?php echo esc_html__('Home Page', 'cookie-opt'); ?>
                                            </option>
                                        </select>
                                    <?php elseif ($rule['type'] == 'page'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][show][<?php echo esc_attr($key) ?>][value]">
                                            <?php foreach ($data['setting']['all_page'] as $key => $item): ?>
                                                <option <?php $this->propSelected($rule['value'], $item->ID) ?>
                                                    value="<?php echo esc_attr($item->ID) ?>">
                                                    <?php echo esc_html($item->post_title); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php elseif ($rule['type'] == 'post_type'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][show][<?php echo esc_attr($key) ?>][value]">
                                            <?php foreach ($data['setting']['all_post_type'] as $key => $value): ?>
                                                <option <?php $this->propSelected($rule['value'], $key) ?>
                                                    value="<?php echo esc_attr($key) ?>">
                                                    <?php echo esc_html($value); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php elseif ($rule['type'] == 'user_type'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][show][<?php echo esc_attr($key) ?>][value]">
                                            <option <?php $this->propSelected($rule['value'], 'login') ?> value="login">
                                                <?php echo esc_html__('Login user', 'cookie-opt'); ?>
                                            </option>
                                            <option <?php $this->propSelected($rule['operator'], 'guest') ?> value="guest">
                                                <?php echo esc_html__('Guest', 'cookie-opt'); ?>
                                            </option>
                                        </select>
                                    <?php endif; ?>

                                    <i class="coop-icon--close coop-item__pointer"
                                        data-remove="<?php echo esc_attr($key) ?>">x</i>
                                </div>
                                <span>
                                    <?php echo esc_html('or', 'cookie-opt') ?>
                                </span>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <!-- Rules list hidden -->
                <div data-group="coop-group__conditionals-hide" class="coop-container">
                    <?php if (count($data['setting']['conditional']['rules']['hide']) !== 0): ?>
                        <?php foreach ($data['setting']['conditional']['rules']['hide'] as $key => $rule): ?>
                            <div data-id="<?php echo esc_attr($key) ?>" class="coop-rule">
                                <div data-id="<?php echo esc_attr($key) ?>" class="coop-form__group coop-form__group--inline">
                                    <!-- Type conditional -->
                                    <select class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__type"
                                        name="coop-setting__conditional[rule][hide][<?php echo esc_attr($key) ?>][type]">
                                        <option <?php $this->propSelected($rule['type'], 'page_type') ?> value="page_type">
                                            <?php echo esc_html__('Page Type', 'cookie-opt') ?>
                                        </option>
                                        <option <?php $this->propSelected($rule['type'], 'page') ?> value="page">
                                            <?php echo esc_html__('Page', 'cookie-opt') ?></option>
                                        <option <?php $this->propSelected($rule['type'], 'post_type') ?> value="post_type">
                                            <?php echo esc_html__('Post Type', 'cookie-opt') ?></option>
                                        <option <?php $this->propSelected($rule['type'], 'user_type') ?> value="user_type">
                                            <?php echo esc_html__('User Type', 'cookie-opt') ?></option>
                                    </select>

                                    <!-- Operator -->
                                    <select class="coop-form__control coop-form__control--md coop-h--fit"
                                        name="coop-setting__conditional[rule][hide][<?php echo esc_attr($key) ?>][operator]">
                                        <option <?php $this->propSelected($rule['operator'], 'equal') ?> value="equal">
                                            <?php echo esc_html__('Equal to', 'cookie-opt'); ?>
                                        </option>
                                        <option <?php $this->propSelected($rule['operator'], 'not-equal') ?> value="not-equal">
                                            <?php echo esc_html__('Not equal to', 'cookie-opt'); ?>
                                        </option>
                                    </select>

                                    <!-- Group Value Type Conditional - Hide list -->
                                    <?php if ($rule['type'] == 'page_type'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][hide][<?php echo esc_attr($key) ?>][value]">
                                            <option <?php $this->propSelected($rule['value'], 'front') ?> value="front">
                                                <?php echo esc_html__('Front Page', 'cookie-opt'); ?>
                                            </option>
                                            <option <?php $this->propSelected($rule['value'], 'home') ?> value="home">
                                                <?php echo esc_html__('Home Page', 'cookie-opt'); ?>
                                            </option>
                                        </select>
                                    <?php elseif ($rule['type'] == 'page'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][hide][<?php echo esc_attr($key) ?>][value]">
                                            <?php foreach ($data['setting']['all_page'] as $page): ?>
                                                <option <?php $this->propSelected($rule['value'], $page->ID) ?>
                                                    value="<?php echo esc_attr($page->ID) ?>">
                                                    <?php echo esc_html($page->post_title) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php elseif ($rule['type'] == 'post_type'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][hide][<?php echo esc_attr($key) ?>][value]">
                                            <?php foreach ($data['setting']['all_post_type'] as $post_type => $value): ?>
                                                <option <?php $this->propSelected($rule['value'], $post_type) ?>
                                                    value="<?php echo esc_attr($post_type) ?>">
                                                    <?php echo (esc_html($value)); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php elseif ($rule['type'] == 'user_type'): ?>
                                        <select
                                            class="coop-form__control coop-form__control--md coop-h--fit coop-conditional__value"
                                            name="coop-setting__conditional[rule][hide][<?php echo esc_attr($key) ?>][value]">
                                            <option <?php $this->propSelected($rule['value'], 'login') ?> value="login">
                                                <?php echo esc_html__('Login user', 'cookie-opt'); ?>
                                            </option>
                                            <option <?php $this->propSelected($rule['value'], 'guest') ?> value="guest">
                                                <?php echo esc_html__('Guest', 'cookie-opt'); ?>
                                            </option>
                                        </select>
                                    <?php endif; ?>

                                    <i class="coop-icon--close coop-item__pointer"
                                        data-remove="<?php echo esc_attr($key) ?>">x</i>
                                </div>
                                <span>
                                    <?php echo esc_html('or', 'cookie-opt') ?>
                                </span>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <br>
                <button id="setting__add-rule" type="button"
                    class="coop-button coop-button__primary"><?php echo esc_html__('✙Add Condition', 'cookie-opt') ?></button>

                <div class="coop-form__group coop-item__left">
                    <span>
                        <?php echo esc_html__('Create rules to precisely define the conditions for displaying or hiding the banner.', 'cookie-opt'); ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>